package Direct::Model::Image::Manager;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Manager::Base';

use Settings;
use Yandex::DBShards;
use JavaIntapi::GenerateObjectIds;

has 'items' => (
    is  => 'ro',
    isa => 'ArrayRef[Direct::Model::Image]',
);

sub create
{
    my ($self, $uid, %opt) = @_;

    my $new_ids = JavaIntapi::GenerateObjectIds->new(object_type => 'image',
            count => scalar @{$self->items})->call();

    foreach_shard cid => $self->items, by => sub { $_->campaign_id }, sub {
        my ($shard, $shard_items) = @_;
        $_->id(shift @$new_ids) for @$shard_items;
        $self->_insert_to_one_table_in_db(PPC(shard => $shard), 'images', undef, $shard_items);
    };

}

sub update
{
    my ($self, $uid, %opt) = @_;

    foreach_shard cid => $self->items, by => sub { $_->campaign_id }, sub {
        my ($shard, $shard_items) = @_;
        $self->_update_one_table_in_db(PPC(shard => $shard), 'images', 'image_id', $shard_items);
    };
}

__PACKAGE__->meta->make_immutable;

1;

