package Direct::Model::ImageFormat::Manager;

use Direct::Modern;
use Mouse;

use JSON;

extends 'Yandex::ORM::Model::Manager::Base';

use Settings;

use Yandex::DBTools;
use Yandex::Avatars::MDS;
use Yandex::URL qw/get_host/;

use Direct::Model::ImageFormat;

has 'items' => (
    is  => 'ro',
    isa => 'ArrayRef[Direct::Model::ImageFormat]',
);

has '_items_by_hash' => (
    is  => 'rw',
    isa => 'HashRef',
    default => sub { +{} },
);

=head2 save

=cut

sub save {
    my ($self, %opt) = @_;

    my $shard = $opt{shard};

    my $rows = get_hashes_hash_sql(PPC(shard => $shard), [
        SELECT => Direct::Model::ImageFormat->get_db_columns(banner_images_formats => 'bimf'),
        FROM => 'banner_images_formats bimf',
        WHERE => {
            image_hash => [ map { $_->hash } @{$self->items} ],
        }
    ]);

    my @to_save;
    my $cache = {};
    for (@{$self->items}) {
        $self->_items_by_hash->{$_->hash} = $_;
        if (my $row = $rows->{$_->hash}) {
            my $tmp = Direct::Model::ImageFormat->from_db_hash($row, \$cache, prefix => 'bimf_');
            for my $field (qw/width height mds_group_id/) {
                $_->$field($tmp->$field);
            }
        } else {
            push @to_save, $_;
        }
    }

    if (@to_save) {
        my $errors = $self->_upload_to_avatars(\@to_save, %opt);
        return $errors;
    }

    return {};
}

=head2 _upload_to_avatars

%opt:
    namespace => $namespace
    shard => $shard

returns hash:
    { $image_hash => $error } only if failed to save image with hash $image_hash

=cut

sub _upload_to_avatars
{
    my ($self, $items, %opt) = @_;
    my $upload_result = {};
    my $avatars = Yandex::Avatars::MDS->new(namespace => $opt{namespace});
    my (@to_insert, %errors);
    for my $item (@$items) {
        my $res = eval {
            $avatars->put($item->hash, $item->image);
        };
        if ($@) {
            $errors{$item->hash} = $@;
            next;
        }
        if (!$res->{sizes} || !%{$res->{sizes}}) {
            my $image_hash = $item->hash;
            die "Can not save image (hash $image_hash) without formats";
        }
        if ($res->{sizes}->{orig}->{width} != $item->width || $res->{sizes}->{orig}->{height} != $item->height) {
            die "mds returned invalid size $res->{sizes}->{orig}->{width} x $res->{sizes}->{orig}->{height}, expected @{[$item->width]} x @{[$item->height]}";
        }

        my $meta = $res->{meta};
        if (defined $meta) {
            delete $meta->{NNetFeatures};
            delete $meta->{NeuralNetClasses};
        }

        push @to_insert, [ $item->hash, $res->{'group-id'}, $opt{namespace},
            $item->image_type, $item->width, $item->height, to_json($res->{sizes}),
            get_host($avatars->get_host),
            to_json($res, {canonical => 1})
        ];

        $self->_items_by_hash->{$item->hash}->mds_group_id($res->{'group-id'});
    }

    do_mass_insert_sql(PPC(shard => $opt{shard}),
        'insert into banner_images_formats
        (image_hash, mds_group_id, namespace, image_type, width, height, formats, avatars_host, mds_meta)
        values %s', \@to_insert);

    return \%errors;
}

1;
