package Direct::Model::Keyword;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::ORM::Helpers qw/mysql_timestamp_around/;

use Direct::Model::Keyword::BsData;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::Update';

__PACKAGE__->_setup(
    default_table  => 'bids',

    fields => [
        id                  => { type => 'Id64', column => 'id', primary_key => 1 },
        adgroup_id          => { type => 'Id', column => 'pid' },
        campaign_id         => { type => 'Id', column => 'cid' },
        text                => { type => 'Str', column => 'phrase' },
        normalized_text     => { type => 'Maybe[Str]', column => 'norm_phrase' },
        words_count         => { type => 'Int', column => 'numword', default => 0 },
        price               => { type => 'Num', default => '0.00' },
        price_context       => { type => 'Num', default => '0.00' },
        autobudget_priority => { type => 'Maybe[Int]', column => 'autobudgetPriority' },
        place               => { type => 'Maybe[Int]' },
        last_change         => { type => 'Timestamp', column => 'modtime' },
        bs_phrase_id        => { type => 'Int', column => 'PhraseID', default => 0 },
        status_moderate     => { type => 'Enum', values => [qw/New Yes No/], column => 'statusModerate', default => 'New', volatile => 1 },
        warn_on_place_lost  => { type => 'Enum', values => [qw/Yes No/], column => 'warn', default => 'No' },
        status_bs_synced    => { type => 'Enum', values => [qw/No Sending Yes/], column => 'statusBsSynced', default => 'No', volatile => 1 },
        optimization_tries  => { type => 'Int', column => 'optimizeTry', default => 0 },
        shows_forecast      => { type => 'Maybe[Int]', column => 'showsForecast', default => 0 },
        is_suspended        => { type => 'Bool', default => 0 },

        # href_params
        href_param1         => { type => 'Maybe[Str]', table => 'bids_href_params', column => 'param1', length => 255 },
        href_param2         => { type => 'Maybe[Str]', table => 'bids_href_params', column => 'param2', length => 255 },

        # phraseid_history
        bs_history          => { type => 'Maybe[Str]', table => 'bids_phraseid_history', column => 'phraseIdHistory' },
    ],

    additional => [
        # $norm_key_words в Lang::Unglue::glue_minus_words. Фразы с одинаковым
        # norm_key_words склеиваются в glue_minus_words в одну. Т.е. по этому
        # ключу и только по нему можно достоверно понять какая фраза склеилась
        # с какой, поэтому его нужно сохранять. normalized_text и md5 от него
        # не подходят, т.к. вычисляются с учетом минус фраз
        collapsing_key      => { type => 'Maybe[Str]', comment => 'Ключ по которому мы схлопываем ключевые слова' },
        bs_data             => { type => 'BsDataT', comment => 'Данные торгов и статистика за 28 дней' },
        ctr_source_id       => { type => 'Maybe[Id64]', comment => 'Id фразы, являющейся источником CTR' },
        ctr_source          => { type => 'Maybe[Str]', comment => 'Сфомированный phraseIdHistory фразы-источника' },
    ],

    relations => [
        adgroup   => { type => 'Direct::Model::AdGroup' },
    ],

    state_flags => [qw/
        bs_sync_adgroup
        moderate_adgroup
        moderate_template_banners
        update_adgroup_last_change
        clear_auto_price_queue
        clear_banners_moderation_flags
        schedule_forecast
        freeze_autobudget_alert

    /],
);

# Allow set to `now`
around last_change => mysql_timestamp_around('last_change');

sub to_template_hash {
    my $hash = shift->to_hash;
    $hash->{autobudgetPriority} = delete $hash->{autobudget_priority} if exists $hash->{autobudget_priority};

    return $hash;
}

1;
