package Direct::Model::Keyword::BsData;

use Direct::Modern;
use Mouse::Util::TypeConstraints;

# Данные, которые ожидаем увидеть в keyword->bs_data
my $EXPECTED_DATA = [
    # Расчитанные Автоброкером данные по фразе
    'cbroker' => [
        'broker_coverage',              #
        'broker_place',                 # Позиция, на которую попадет фраза
        'broker_place_without_coef',    #
        'broker_price',                 # Списываемая цена клика
        'broker_truncated',             #
        'eff_strategy_min_price',       #
    ],

    'broker',       # Алиас для cbroker->broker_price

    'clicks',       # Поиск: Количество кликов за 28 дней
    'shows',        # Поиск: Количество показов за 28 дней
    'ctr',          # Поиск: Расчитанный CTR: clicks/shows

    'ctx_clicks',   # РСЯ: Количество кликов за 28 дней
    'ctx_shows',    # РСЯ: Количество показов за 28 дней
    'cxt_ctr',      # РСЯ: Расчитанный CTR: clicks/shows

    'larr',         # Цены ниже гарантии (серилизованный аналог premium/guarantee)

    'ectr',         # Эффективный CTR ?
    'pectr',        #

    'premium',      # Цены с учетом накопленной статистики для соответствующих блоков
    'guarantee',    # См. предыдущую строку

    # Средневзвешанные цены для блоков (без учета статистики, для прогноза)
    'weighted' => ['guarantee', 'premium'],
];

my $_allowed_keys = {};
for (my $i = 0; $i < @$EXPECTED_DATA; $i++) {
    my $key = $EXPECTED_DATA->[$i];
    $_allowed_keys->{$key} = 1;
    if (exists $EXPECTED_DATA->[$i+1] && ref($EXPECTED_DATA->[$i+1]) eq 'ARRAY') {
        $_allowed_keys->{$key} = {map { $_ => 1 } @{$EXPECTED_DATA->[$i+1]}};
        $i++;
    }
}

subtype 'BsDataT' => as 'HashRef' => where {
    my $val = $_;

    (sub {
        # Ожидаем увидеть только известные ключи в $val
        for my $key (keys %$val) {
            if (!exists $_allowed_keys->{$key}) {
                warn "Found unexpected key `$key`";
                return 0;
            }
            if (ref($_allowed_keys->{$key}) eq 'HASH') {
                for my $subkey (keys %{$val->{$key}}) {
                    if (!exists $_allowed_keys->{$key}->{$subkey}) {
                        warn "Found unexpected key `$key`.`$subkey`";
                        return 0;
                    }
                }
            }
        }
        return 1;
    })->();
};

1;
