package Direct::Model::MediaResource;

use Direct::Modern;
use Mouse;
use JSON;

extends 'Yandex::ORM::Model::Base';

use JSON;

__PACKAGE__->_setup(
    default_table => 'media_resources',

    fields        => [
        id                  => { type => 'Id', column => 'media_resource_id', primary_key => 1 },
        resource_type       => { type => 'Enum', values => [ qw/video audio/ ] },
        name                => { type => 'Str' },
        yacontextCategories => { type => 'Maybe[Str]' },
        colors              => { type => 'Str' },
        preview_url         => { type => 'Maybe[Str]' },
        resources_url       => { type => 'Maybe[Str]' },
    ],

    additional => [
        used_resources      => { type => 'Maybe[Str]' },
    ]
);

around BUILDARGS => sub {
    my ($orig, $class, %args) = @_;
    $args{used_resources} //= to_json([$args{id}]);
    return $class->$orig(%args);
};

sub to_template_hash {
    my $self = shift;
    return {
        id   => $self->id,
        name => $self->name,
        type => $self->resource_type,
        urls => JSON::from_json($self->resources_url),
    }
}

1;
