package Direct::Model::MetrikaCounter::Manager;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Manager::Base';

use Settings;

use Yandex::DBTools;
use Yandex::DBShards;
use List::MoreUtils qw/uniq/;

use Direct::Model::MetrikaCounter;

has 'items' => (is  => 'ro', isa => 'ArrayRef[Direct::Model::MetrikaCounter]');

=head2 update

Обновление в БД записей для соответствующих объектов (счетчиков метрики).

=cut

sub update {
    my ($self) = @_;

    # Обработаем объекты по шардам
    for my $chunk (sharded_chunks(cid => $self->items, by => sub { $_->campaign_id }, chunk_size => $self->_max_items_to_update)) {
        my ($shard, $shard_items) = ($chunk->{shard}, $chunk->{cid});

        my %case_values;
        for my $x (@$shard_items) {
            while (my ($column, $state) = each %{$x->_db_state->{'metrika_counters'}}) {
                next unless $state->[0]; # is_changed
                $case_values{$column}->{$x->campaign_id}->{$x->id} = $x->get_db_column_value('metrika_counters', $column);
            }
        }

        for my $column (keys %case_values) {
            for my $campaign_id (keys %{$case_values{$column}}) {
                $case_values{$column}->{$campaign_id} = sql_case(
                    metrika_counter => $case_values{$column}->{$campaign_id}, default__dont_quote => $column,
                );
            }
        }

        do_in_transaction {
            # Получаем монструозную конструкцию для двух ключей
            my @cids_to_update = uniq(map { keys %$_ } values %case_values);
            do_update_table(PPC(shard => $shard), 'metrika_counters', {
                (map { $_ => sql_case(cid => $case_values{$_}, default__dont_quote => $_, dont_quote_value => 1) } keys %case_values),
            }, where => {
                cid => \@cids_to_update,
            }, dont_quote => [keys %case_values]) if @cids_to_update;

            # Обработаем флаги
            $self->_do_update_campaigns($shard, $shard_items);
        };
    }

    $_->reset_state() for @{$self->items};

    return;
}

sub _do_update_campaigns {
    my ($self, $shard, $counters) = @_;

    $counters = [grep { $_->do_bs_sync_campaign } @$counters];
    return if !@$counters;

    my @cids = uniq(map { $_->campaign_id } @$counters);
    do_update_table(PPC(shard => $shard), 'campaigns', {statusBsSynced => 'No',}, where => {cid => \@cids});

    return;
}

__PACKAGE__->meta->make_immutable;

1;
