package Direct::Model::MetrikaGoal;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';

use constant GOAL_TYPE => ['url', 'number', 'step', 'action', 'ecommerce', 'offline', 'call', 'form', 'email', 'phone', 'cdp_order_in_progress',
    'cdp_order_paid', 'messenger', 'file', 'search', 'button', 'e_cart', 'e_purchase', 'a_cart', 'a_purchase', 'conditional_call', 'social', 'payment_system', 'contact_data'];

__PACKAGE__->_setup(
    default_table  => 'metrika_goals', # ppcdict

    fields => [
        goal_id                    => { type => 'Id', primary_key => 1 },
        goal_name                  => { type => 'Str', length => 255 },
        counter_status             => { type => 'Enum', values => [qw/Active Deleted/], default => 'Active' },
        goal_status                => { type => 'Enum', values => [qw/Active Deleted/], default => 'Active' },
        goal_type                  => { type => 'Enum', values => GOAL_TYPE, default => 'url' },
        parent_goal_id             => { type => 'Int' },
        goals_count                => { type => 'Int' },
        context_goals_count        => { type => 'Int' },
        goal_source                => { type => 'Enum', values => [qw/user auto/], default => 'user' },
    ]
);

1;
