package Direct::Model::PerformanceFilter::Rule;

use Direct::Modern;
use Mouse::Util::TypeConstraints;
use Carp qw/croak/;

use Yandex::ORM::Types;
use Yandex::I18n;
use FilterSchema;

use Mouse;

use List::MoreUtils qw/any/;

has filter_type => (is => 'ro', isa => 'Str'  );
has _schema  => (is => 'ro', isa => 'HashRef');
has value    => (is => "rw", isa => "Maybe[NonEmptyStr|ArrayRef]", predicate => 'has_value');

around BUILDARGS => sub {
    my ($orig, $class) = (shift, shift);
    my %args = @_ == 1 && ref($_[0]) eq 'HASH' ? %{$_[0]} : @_;
    unless ($args{filter_type}) {
        die "filter_type required";
    }
    
    my $filter_type = $args{filter_type};
    
    my $schema = FilterSchema->new(filter_type => $filter_type)->schema;
    $args{_schema} = $schema;


    $class->meta->add_attribute(field => ( is => 'ro',
            isa => maybe_type(enum($filter_type.'_'.EnumFields => [ keys %{ $schema->{definitions}->{rule} } ] ))));
    $class->meta->add_attribute(relation => ( is => 'ro',
            isa => maybe_type(enum($filter_type.'_'.EnumRelations => [ @{$schema->{definitions}->{all_relations} || []} ]  ))));

    $class->$orig(%args);
};

sub to_hash {
    my ($self) = @_;
    return {
        field => $self->field,
        relation => $self->relation,
        value => $self->value,
    };
}

sub from_json_key_val {
    my ($class, $data, %opt) = @_;
    
    my ($predicate, $value) = %$data;
    
    croak sprintf ('Invalid rule: %s => %s', $predicate, $value) unless defined $predicate && defined $value;
    my ($field, $relation) = split / /, $predicate, 2;
    $relation = '==' if !defined($relation);

    return $class->new(field => $field, relation => $relation, value => $value, %opt );
}

sub to_json_key_val {
    my ($self) = @_;
    my @relation = $self->relation eq '==' && (any { $self->field eq $_ } qw/url name vendor/) ? () : ($self->relation);
    return (join(' ', $_->field, @relation) => $_->value);
}

sub to_string {
    my ($self) = @_;

    return join ' ', (
        $self->field,
        iget($self->_schema->{definitions}->{translations}->{rule}->{$self->relation} // $self->relation),
        $self->relation ne 'exists' ? (join ', ', @{$self->value // []} ) : (),
    )
}

1;
