package Direct::Model::Pixel::Manager;

use Direct::Modern;
use Mouse;
use List::MoreUtils qw/uniq part/;

use Yandex::DBShards;
use Yandex::DBTools;

use Settings;
use Direct::Model::Pixel;

extends 'Yandex::ORM::Model::Manager::Base';

has 'items' => (
    is  => 'ro',
    isa => 'ArrayRef[Direct::Model::Pixel]',
);

=head2 save

Сохранение пикселов

=cut

sub save {
    my ($self) = @_;
    my @columns = Direct::Model::Pixel->get_db_columns_list('banner_pixels');

    for my $chunk (sharded_chunks(bid => $self->items, by => sub { $_->banner_id })) {
        my ($shard, $shard_items) = ($chunk->{shard}, $chunk->{bid});

        my @bids = uniq(map { $_->banner_id } @$shard_items);
        do_in_transaction {
            # получаем пикселы, которые уже есть в базе
            my $pixels_data = get_all_sql(PPC(shard => $shard), [ 'SELECT pixel_id, bid, pixel_url FROM banner_pixels', WHERE => { bid => \@bids }, q/lock in share mode/ ]);
            my %db_pixels = map { Direct::Model::Pixel->uniq_key($_->{bid}, $_->{pixel_url}) => $_ } @$pixels_data;

            my ($new_pixels, $old_pixels) = part { !$db_pixels{$_->uniq_key} ? 0 : 1 } @$shard_items;

            my $new_pixel_ids = {};
            if ($new_pixels) {
                my $pixel_ids = get_new_id_multi(pixel_id => scalar(@$new_pixels));
                for my $new_pixel (@$new_pixels) {
                    $new_pixel->id(pop @$pixel_ids);
                    $new_pixel_ids->{$new_pixel->uniq_key} = $new_pixel->id;
                }
                $self->_insert_to_one_table_in_db(PPC(shard => $shard), 'banner_pixels', \@columns, $new_pixels);
            }

            for my $pixel (@$shard_items) {
                unless ($pixel->has_id) {
                    $pixel->id($new_pixel_ids->{$pixel->uniq_key} || $db_pixels{$pixel->uniq_key}->{pixel_id});
                }
                delete $db_pixels{$pixel->uniq_key};
            }

            if (%db_pixels) { # остались пиксели, которые надо удалить
                do_sql(PPC(shard => $shard), [ 'DELETE FROM banner_pixels',
                    WHERE => { _OR => [ map {( _AND => { bid => $_->{bid}, pixel_id => $_->{pixel_id} } )} values %db_pixels ] } ]);
            }
        }
    }

    return;
}

1;
