package Direct::Model::Pixel::Utils;

use Direct::Modern;

use Yandex::DBTools;

use Settings;

use Direct::Model::Pixel;

=head2 get_permitted_providers($client_id)

    Получаем провайдеров пикселов, разрешенных для заданного $client_id, в виде хэша, где ключи - провайдеры

=cut

sub get_permitted_providers {
    my ($client_id) = @_;

    my %permitted_providers;
    push @{$permitted_providers{$_->{provider}}{$_->{campaign_type}}}, $_->{criterion_type} foreach @{_permitted_providers_data($client_id)};

    return \%permitted_providers;
}

=head2 get_permitted_providers_by_campaign_types($client_id)

    Получаем провайдеров пикселов, разрешенных для заданного $client_id, в виде хэша, где ключи - типы кампаний

=cut

sub get_permitted_providers_by_campaign_types {
    my ($client_id) = @_;

    my %permitted_providers;
    foreach my $item (@{_permitted_providers_data($client_id)}) {
        push @{$permitted_providers{$item->{campaign_type}}{$item->{criterion_type}}}, $item->{provider};
        # разрешения для неизвестного инвентаря формируем из разрешений для известного по определенным правилам
        if ($item->{campaign_type} eq 'cpm_deals'
            && exists $Direct::Model::Pixel::PROVIDERS_DATA{$item->{provider}}{criterion_type_for_unknown}
            && $Direct::Model::Pixel::PROVIDERS_DATA{$item->{provider}}{criterion_type_for_unknown} eq $item->{criterion_type}) {
            push @{$permitted_providers{$item->{campaign_type}}{unknown}}, $item->{provider};
        }
    }

    return \%permitted_providers;
}


sub _permitted_providers_data {
    my ($client_id) = @_;

    return get_all_sql(PPC(ClientID => $client_id),
        ['SELECT provider, campaign_type, criterion_type FROM client_pixel_providers', WHERE => { ClientID => $client_id }]
    );
}

1;
