package Direct::Model::Retargeting;

use Direct::Modern;
use Mouse;

use Yandex::ORM::Helpers qw/mysql_timestamp_around/;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::Update';

__PACKAGE__->_setup(
    default_table  => 'bids_retargeting',

    fields => [
        id                  => { type => 'Id', column => 'ret_id', primary_key => 1 },
        adgroup_id          => { type => 'Id', column => 'pid' },
        ret_cond_id         => { type => 'Id' },
        campaign_id         => { type => 'Id', column => 'cid' },
        price_context       => { type => 'Num', default => '0.00' },
        autobudget_priority => { type => 'Maybe[Int]', column => 'autobudgetPriority' },
        status_bs_synced    => { type => 'Enum', values => [qw/No Sending Yes/], column => 'statusBsSynced', default => 'No', volatile => 1 },
        is_suspended        => { type => 'Bool', default => 0 },
        last_change         => { type => 'Timestamp', column => 'modtime' },
    ],


    relations => [
        adgroup         => { type => 'Direct::Model::AdGroup', key => 'adgroup_id' },
        ret_cond        => { type => 'Direct::Model::RetargetingCondition' },
    ],

    state_flags => [qw/
        bs_sync_adgroup
        update_adgroup_last_change
    /],
);

sub ret_id { shift->id(@_) }

# Allow set to `now`
around last_change => mysql_timestamp_around('last_change');

override to_db_hash => sub {
    my ($self) = @_;
    my $hash = super();
    $hash->{cid} = $self->campaign_id if $self->has_campaign_id;
    return $hash;
};

1;
