package Direct::Model::RetargetingCondition::Goal;

use Direct::Modern;
use Mouse;
use List::MoreUtils qw/any/;
use Mouse::Util::TypeConstraints;

use Yandex::ORM::Types;

use Settings qw//;
use Primitives qw//;

has goal_id     => (is => 'rw', isa => 'Id', required => 1);
has goal_type   => (is => 'rw',
		    isa => enum(['goal', 'segment', 'lal_segment', 'mobile', 'audience', 'social_demo', 'family', 'interests', 'ecommerce', 'ab_segment', 'cdp_segment', 'behaviors', 'audio_genres', 'brandsafety', 'content_category', 'content_genre', 'host']),
		    builder => '_build_goal_type');
has time        => (is => 'rw', isa => 'Maybe[Int]', predicate => 'has_time');
has union_with_id => (is => 'rw', isa => 'Maybe[Id]', predicate => 'has_union_with_id');

around BUILDARGS => sub {
    my ($orig, $class) = (shift, shift);
    my %args = @_ == 1 && ref($_[0]) eq 'HASH' ? %{$_[0]} : @_;

    # goal_type игнорируем (всегда вычисляем)
    delete $args{goal_type};

    if (($args{goal_id} // 0) > 0) {
        my $goal_type = Primitives::get_goal_type_by_goal_id($args{goal_id});

        # для goal_type == audience, time заполняем значением по умолчанию
        if ($goal_type eq 'audience') {
            $args{time} = $Settings::MAX_RETARGETING_GOAL_TIME_DAYS;
        } elsif ((any {$_ eq $goal_type} qw/social_demo family interests ab_segment behaviors audio_genres brandsafety/)) {
            # time для таргетингов Крипты устанавливаем в 0
            $args{time} = 0;
        } elsif (!defined $args{time}) {
            # а для всех остальных обязателен
            die 'time is required for this type of goal';
        }
    }

    $class->$orig(%args);
};

sub _build_goal_type {
    my $self = shift;
    return Primitives::get_goal_type_by_goal_id($self->goal_id);
}

sub to_hash {
    my $self = shift;
    my %options = @_;
    return {
        goal_id => int($self->goal_id),
        (!$options{json} ? (goal_type => $self->goal_type) : ()), # dont add goal_type to json
        $self->has_time ? (time => int($self->time)) : (),
        $self->has_union_with_id ? (union_with_id => int($self->union_with_id)) : (),
    };
}

1;
