package Direct::Model::RetargetingCondition::Rule;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Direct::Model::RetargetingCondition::Goal;

subtype 'RetargetingGoalsArrayRef'
    => as 'ArrayRef[Direct::Model::RetargetingCondition::Goal]'; # => where { scalar(@$_) > 0 };

coerce 'RetargetingGoalsArrayRef'
    => from 'ArrayRef[HashRef]'
    => via { [map { Direct::Model::RetargetingCondition::Goal->new($_) } @$_] };

has type          => (is => "rw", isa => enum(['all', 'not', 'or']), required => 1);
has interest_type => (is => 'rw', isa => 'Maybe[Str]');
has goals         => (is => "rw", isa => 'RetargetingGoalsArrayRef', required => 1, coerce => 1);
has section_id    => (is => 'rw', isa => 'Maybe[Id]');

sub to_hash {
    my $self = shift;
    my %options = @_;
    my $result = {
        type => $self->type,
        goals => [map { $_->to_hash(%options) } @{$self->goals}],
    };
    if (exists $self->{interest_type}) {
        $result->{interest_type} = $self->interest_type;
    }
    if (exists $self->{section_id}) {
        $result->{section_id} = $self->section_id;
    }
    return $result;
}

1;

