package Direct::Model::Role::Banner::WithVideoAddition;

use Direct::Modern;
use Mouse::Role;

sub is_creative_changed
{
    my $self = shift;
    if (!$self->old) {
        if (!$self->has_creative) {
            return 0;
        }
        return 1; # у нового баннера креатив считаем измененным, чтобы сразу отправить на модерацию
    }

    if (!$self->has_creative) {
        return $self->old->has_creative ? 1 : 0;
    }

    my $old_creative = $self->old_creative;
    if ($old_creative && $self->has_creative && $self->creative->has_creative) {
        return 1 if $old_creative->resource_type ne $self->creative->creative->resource_type
            || $old_creative->id != $self->creative->creative->id;
    }

    return $self->creative->is_creative_id_changed || ( !$self->old->has_creative && $self->has_creative );
}

sub old_creative
{
    my $self = shift;
    if ($self->old && $self->old->has_creative && $self->old->creative->has_creative
        && $self->old->creative->creative
    ) {
        return $self->old->creative->creative;
    }
    return undef;
}

1;
