package Direct::Model::Role::Update;

use Direct::Modern;
use Mouse::Role;

has old => (
    is         => 'rw',
    isa        => 'Yandex::ORM::Model::Base',
    lazy_build => 1,
    predicate  => 'has_old',
);

=head2 merge_with($src, %params)

    $banner->merge_with($src_banner);

В примере выше: из $src будут взяты все присутствующие поля (по предикату: has_{field}), и применены к $banner.
При этом, копия оригинального объекта сохранится в $banner->old атрибуте.

Параметры:

    $src -> объект, значения соответствующих полей которого планируется применить к целевому объекту.

    %params:
        exclude -> ARRAYREF, список полей, которые нужно исключить из мёрджа

=cut

sub merge_with {
    my ($self, $src, %params) = @_;

    my %exclude = ((map { $_ => 1 } @{$params{exclude} // []}), old => 1);

    $self->old($self->clone);

    for my $attr (grep { !$exclude{$_->name} } $src->get_public_attributes) {
        next unless $attr->has_value($src);
        my $new = $attr->get_value($src);
        # не перезаписываем одинаковые значения, чтобы не нарваться на попытку выставить
        # дефолтные read-only значения
        if ($attr->has_value($self)) {
            my $old = $attr->get_value($self);
            next unless defined($new) && defined($old) ? $new ne $old : defined($new) || defined($old);
        }
        $attr->set_value($self, $new);
    }

    return;
}

1;
