package Direct::Model::Sitelink;

use Direct::Modern;
use Mouse;

use HashingTools qw/url_hash_utf8/;
use List::MoreUtils qw/all/;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table  => 'sitelinks_links',

    fields => [
        id          => { type => 'Id', column => 'sl_id', primary_key => 1 },
        title       => { type => 'Str', length => 255, trigger => _on_field_changed__tr('title') },
        description => { type => 'Maybe[Str]', length => 1024, trigger => _on_field_changed__tr('description') },
        href        => { type => 'Str', length => 1024, trigger => _on_field_changed__tr('href') },
        hash        => { type => 'Int' },
        tl_id       => { type => 'Maybe[Id]', trigger => _on_field_changed__tr('tl_id') },
    ],
    
    relations => [
        turbolanding => { type => 'Direct::Model::TurboLanding::Sitelink', key => 'tl_id' },
    ],
);

around BUILDARGS => sub {
    my ($orig, $class, %attr) = @_;

    $attr{turbolanding} //= {};
    if (ref $attr{turbolanding} eq 'HASH') {
        my $landing = delete $attr{turbolanding};
        $attr{tl_id} //= $landing->{id};
        $attr{turbolanding} = Direct::Model::TurboLanding::Sitelink->new(%$landing) if $landing->{client_id};
    }
    
    return $class->$orig(%attr);
};

sub _on_field_changed__tr {
    my $attr = shift;
    return sub {
        my ($self, $new) = @_;
        return unless all { my $has = "has_$_"; $self->$has } grep { $_ ne $attr } qw/title description href tl_id/;
        my ($title, $description, $href, $tl_id) = map { $attr eq $_ ? $new : $self->$_ } qw/title description href tl_id/;
        return $self->hash(url_hash_utf8($title . $href . ($description // '').($tl_id // '')));
    };
}

sub get_uhash { return join(':', $_[0]->hash, $_[0]->title, $_[0]->href, ($_[0]->tl_id // ())) }

1;
