package Direct::Model::SitelinksSet;

use Direct::Modern;
use Mouse;

use HashingTools qw/url_hash_utf8/;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table  => 'sitelinks_sets',

    fields => [
        id        => { type => 'Id', column => 'sitelinks_set_id', primary_key => 1 },
        client_id => { type => 'Id', column => 'ClientID' },
        hash      => { type => 'Int', column => 'links_hash' },
    ],

    relations => [
        links   => { type => 'ArrayRef[Direct::Model::Sitelink]' },
    ],
);

sub calculate_hash {
    my ($self) = @_;
    for my $sitelink (@{$self->links}) {
        croak "Found sitelink without id" if !$sitelink->id;
        croak "Found unsaved sitelink" if $sitelink->is_changed;
    }
    $self->hash(url_hash_utf8(join(',', map { $_->id } @{$self->links})));
}

sub get_uhash { join(':', $_[0]->client_id, $_[0]->hash) }

1;
