package Direct::Model::TargetCategory;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;
use Yandex::I18n;

use Yandex::ORM::Helpers qw/mysql_timestamp_around/;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table => 'targeting_categories',

    fields        => [
        id             => { type => 'Id', column => 'category_id', primary_key => 1 },
        parent_id      => { type => 'Maybe[Id]', column => 'parent_category_id' },
        import_id      => { type => 'Int' },
        targeting_type => { type => enum([ 'rmp_interest' ]), builder => sub { 'rmp_interest' } },
        original_name  => { type => 'Maybe[Str]' },
        name           => { type => 'Str' },
        state          => { type => enum([ 'New', 'Submitted', 'Deleted' ]), builder => sub { 'New' } },
        order_num      => { type => 'Int', default => 0 },
        last_change    => { type => 'Timestamp', column => 'last_change' },
    ],

    additional => [
        available      => { type => 'Bool' },
    ],
);

# Allow set to `now`
around last_change => mysql_timestamp_around('last_change');

sub to_template_hash {
    my $self = shift;

    return {
        target_category_id => $self->id,
        name               => iget($self->name),
        order_num          => $self->order_num,
        available          => $self->available,
    };
}

1;
