package Direct::Model::TargetInterest;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Retargeting';

__PACKAGE__->_setup(
    default_table => 'bids_retargeting',

    additional    => [
        target_category_id => { type => 'Int' },
        category_name      => { type => 'Str' },
    ],
);

override to_db_hash => sub {
        my ($self) = @_;
        my $hash = super();
        $hash->{target_category_id} = $self->target_category_id;
        $hash->{category_name} = $self->category_name;
        return $hash;
    };

1;
