package Direct::Model::TurboLanding;

use Direct::Modern;
use Mouse;
use JSON;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::Update';


__PACKAGE__->_setup(
    default_table  => 'turbolandings',

    fields => [
        id                        => { type => 'Id', column => 'tl_id', primary_key => 1 },
        client_id                 => { type => 'Id', column => 'ClientID' },
        name                      => { type => 'Str', length => 255},
        href                      => { type => 'Str'},
        metrika_counters_json     => { type => 'Maybe[Str]'},
    ],
    
    additional => [
        metrica_counters          => {
            type => 'Maybe[ArrayRef[Maybe[HashRef]]]',
            trigger => \&_on_metrica_counters_changed,
            lazy => 1,
            builder => '_build_metrica_counters',
        },
    ],
);

around from_db_hash => sub {
    my ($orig, $class, $db_hash, @rest) = @_;
    
    $db_hash->{tl_id} //= $db_hash->{id};
    
    return $class->$orig($db_hash, @rest);
};

sub to_template_hash {
    my ($self, %opt) = @_;
    
    my $prefix = $opt{prefix} // '';
    
    return {
        map { $prefix.$_ => $self->$_} $self->_fields_for_template()
    };
}

=head2
    Метод класса.
    Формирует из структуры туболендинга, возвращаемой констуктором,
    структуру пригодную для создания модели
=cut

sub from_bs_response_to_hash {
    my ($class, $client_id, $bs_tl) = @_;
    
    my $id = $bs_tl->{id};
    return (
        $id => {
            tl_id       => $id,
            client_id   => $client_id,
            name        => $bs_tl->{name},
            href        => $bs_tl->{url},
            metrika_counters_json => ref $bs_tl->{counters} ? to_json($bs_tl->{counters}) : $bs_tl->{counters},
        }
    );
}

sub _fields_for_template {
    return qw/id name href/
}

sub _on_metrica_counters_changed {
    my ($self, $new) = @_;
    
    if (defined $new) {
        $self->metrika_counters_json(to_json($new))
    }
    else {
        $self->metrika_counters_json(undef);
    }
}

sub _build_metrica_counters {
    my ($self) = @_;
    
    return defined $self->metrika_counters_json ? from_json($self->metrika_counters_json) : undef;
}

1;

