package Direct::Model::TurboLanding::Banner;

use Direct::Modern;
use Mouse;

extends 'Direct::Model::TurboLanding';

__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',
    
    fields => [
        id       => { type => 'Id',  table => 'banner_turbolandings', column => 'tl_id' },
        bid      => { type => 'Id',  table => 'banner_turbolandings' },
        cid      => { type => 'Id',  table => 'banner_turbolandings' },
        status_moderate  => {
            type => 'Enum',
            values => [qw/Yes No Sent Sending Ready New/],
            column => 'statusModerate',
            table => 'banner_turbolandings'
        },
    ],
    relations => [
        banner => { type => 'Direct::Model::Banner', key => 'bid' },
    ]
);

override _fields_for_template => sub {
    return super(), qw /status_moderate bid/;
};

1;

