package Direct::Model::TurboLanding::Banner::Manager;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Manager::Base';

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;

has 'items' => (
    is  => 'ro',
    isa => 'ArrayRef[Direct::Model::TurboLanding::Banner]',
);


=head2 create

Создание в БД записей для добавляемых к баннерам турболендингам

=cut

sub create {
    my ($self) = @_;
    
    $self->_call_by_shard('_create_in_shard');
    
    return;
}

sub _create_in_shard {
    my ($self, $shard, $landings) = @_;

    my @columns = Direct::Model::TurboLanding::Banner->get_db_columns_list('banner_turbolandings');
    
    # Создадим записи в таблице `banner_turbolandings`
    $self->_insert_to_one_table_in_db(PPC(shard => $shard), 'banner_turbolandings', \@columns, $landings);
}

sub update {
    my ($self) = @_;
    
    $self->_call_by_shard('_update_in_shard');
    
    return;
}

sub _update_in_shard {
    my ($self, $shard, $landings) = @_;

    # Обновим таблицу `banner_turbolandings`
    # Т.к. к каждому баннеру может быть привязан только один турболендинг - обновим по bid, чтобы не усложнять запрос
    $self->_update_one_table_in_db(PPC(shard => $shard), banner_turbolandings => 'bid', $landings, pk_field => 'bid');
    
    return;
}

sub delete {
    my ($self) = @_;
    
    $self->_call_by_shard('_delete_in_shard');
    
    return;
}

sub _delete_in_shard {
    my ($self, $shard, $landings) = @_;

    # Удалим записи из`banner_turbolandings`
    # Т.к. к каждому баннеру может быть привязан только один турболендинг - удаляем по bid, чтобы не усложнять запрос

    do_delete_from_table(PPC(shard => $shard), 'banner_turbolandings', where => {bid => [map {$_->bid} @$landings]});
    
    return;
}

sub _call_by_shard {
    my ($self, $method) = @_;
    
        for my $chunk (sharded_chunks(bid => $self->items, by => sub { $_->bid })) {
        $self->$method($chunk->{shard}, $chunk->{bid});
    }

    return;
}

1;
