package Direct::Model::User;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table  => 'users',

    fields => [
        id                        => { type => 'Id', column => 'uid', primary_key => 1 },
        client_id                 => { type => 'Id', column => 'ClientID', default => 0 },
        login                     => { type => 'Str', length => 255 },
        email                     => { type => 'Maybe[Str]', length => 255 },
        fio                       => { type => 'Str', column => 'FIO', length => 255 },
        phone                     => { type => 'Maybe[Str]', length => 255 },
        lang                      => { type => 'Str', length => 2, default => 'ru' },

        # users_options
        status_post_moderate      => { type => 'Enum', values => [qw/Yes No/], table => 'users_options', column => 'statusPostmoderate', default => 'No' },
        tags_allowed              => { type => 'Enum', values => [qw/Yes No/], table => 'users_options', default => 'Yes' },
    ],
);

1;
