package Direct::Model::VCard;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use List::MoreUtils qw/zip/;

extends 'Yandex::ORM::Model::Base';

enum 'VPrecisionT' => [qw/exact number near street other range/];
enum 'VKindT' => [qw/house street metro district locality area province country hydro railway route vegetation cemetery bridge km other/];

subtype 'VPointT'  => as 'Str' => where { /^(?:-?\d+\.\d+),(?:-?\d+\.\d+)$/ };
subtype 'VBoundsT' => as 'Str' => where { /^(?:-?\d+\.\d+),(?:-?\d+\.\d+),(?:-?\d+\.\d+),(?:-?\d+\.\d+)$/ };

__PACKAGE__->_setup(
    default_table  => 'vcards',

    fields => [
        id              => { type => 'Id', column => 'vcard_id', primary_key => 1 },
        campaign_id     => { type => 'Id', column => 'cid' },
        user_id         => { type => 'Id', column => 'uid' },
        address_id      => { type => 'Maybe[Id]' },
        geo_id          => { type => 'Id', default => 0 },
        phone           => { type => 'Maybe[Str]', length => 25 },
        name            => { type => 'Maybe[Str]', length => 255 },
        city            => { type => 'Maybe[Str]', length => 55 },
        contact_person  => { type => 'Maybe[Str]', column => 'contactperson', length => 155 },
        work_time       => { type => 'Maybe[Str]', column => 'worktime', length => 255 },
        country         => { type => 'Maybe[Str]', length => 50 },
        street          => { type => 'Maybe[Str]', length => 55 },
        house           => { type => 'Maybe[Str]', length => 30 },
        building        => { type => 'Maybe[Str]', column => 'build', length => 10 },
        apartment       => { type => 'Maybe[Str]', column => 'apart', length => 100 },
        metro           => { type => 'Maybe[Id]' },
        extra_message   => { type => 'Maybe[Str]' },
        contact_email   => { type => 'Maybe[Str]', length => 255 },
        im_client       => { type => 'Maybe[Str]', length => 25 },
        im_login        => { type => 'Maybe[Str]', length => 255 },

        _org_details_id => { type => 'Maybe[Id]', column => 'org_details_id' },
        ogrn            => { type => 'Maybe[Str]', table => 'org_details', length => 255 },

        # `addresses` table
        _map_id         => { type => 'Maybe[Id]', table => 'addresses', column => 'map_id' },
        _map_id_auto    => { type => 'Maybe[Id]', table => 'addresses', column => 'map_id_auto' },
        auto_precision  => { type => 'Maybe[VPrecisionT]', table => 'addresses', column => 'precision', alias => 'auto_precision' },
        auto_kind       => { type => 'Maybe[VKindT]', table => 'addresses', column => 'kind', alias => 'auto_kind' },
    ],

    additional => [
        manual_point    => { type => 'Maybe[VPointT]', track_changes => 1 },
        manual_bounds   => { type => 'Maybe[VBoundsT]', track_changes => 1 },
        auto_point      => { type => 'Maybe[VPointT]' },
        auto_bounds     => { type => 'Maybe[VBoundsT]' },
    ],
);

sub parsed_phone {
    my ($self) = @_;
    my @keys = qw/country_code city_code phone_short phone_ext/;
    my @vals = map { $_ // '' } (split '#', $self->phone // '')[0..3];
    return {zip @keys, @vals};
}

sub to_db_hash {
    my ($self) = @_;
    my $db_hash = $self->SUPER::to_db_hash();
    for my $attr_name (qw/manual_point manual_bounds auto_point auto_bounds/) {
        $db_hash->{$attr_name} = $self->$attr_name if $self->can("has_${attr_name}")->($self);
    }
    return $db_hash;
}

1;
