package Direct::Model::Wallet;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table  => 'wallet_campaigns',

    fields => [
        id                         => { type => 'Id', column => 'wallet_cid', primary_key => 1 },
        autopay_mode               => { type => 'Enum', values => [qw/none min_balance/], default => 'none' },
        # поля ниже читаются, но не сохраняются в БД
        is_sum_aggregated          => { type => 'Enum', values => [qw/Yes No/], default => 'No' },
        client_id                  => { type => 'Id', column => 'ClientID', table => 'campaigns' },
        user_id                    => { type => 'Id', column => 'uid', table => 'campaigns' },
        manager_user_id            => { type => 'Maybe[Id]', column => 'ManagerUID', table => 'campaigns' },
        agency_id                  => { type => 'Id', column => 'AgencyID', table => 'campaigns', default => 0 },
        agency_user_id             => { type => 'Maybe[Id]', column => 'AgencyUID', table => 'campaigns' },
        currency                   => { type => 'Str', table => 'campaigns' },
        email                      => { type => 'Maybe[Str]', length => 255, table => 'camp_options' },
        client_fio                 => { type => 'Maybe[Str]', length => 255, table => 'camp_options', column => 'FIO' },
    ],

    additional => [
        autopay                    => { type => 'Maybe[Direct::Model::Autopay]', track_changes => 1 },
        allow_pay                  => { type => 'Maybe[Bool]'},
    ],

);
sub is_active_autopay {
	my ($self) = @_;
	return $self->autopay_mode ne 'none';
}
1;
