package Direct::Model::Wallet::Manager;

use Direct::Modern;
use Mouse;
#use POSIX qw/strftime/;

use Settings;

use Yandex::DBTools;
use Yandex::DBShards;

use Direct::Model::Autopay;

extends 'Yandex::ORM::Model::Manager::Base';

has 'items' => (
    is  => 'ro',
    isa => 'ArrayRef[Direct::Model::Wallet]',
);

=head2 update

    Обновление в БД данных про кошелек.
    На данном этапе это только создание и сохранение записей для настроек автоплатежа.

=cut
sub update {
    my ($self) = @_;

    my @columns = Direct::Model::Autopay->get_db_columns_list('autopay_settings');
    foreach my $wallet (@{$self->items}) {

        do_in_transaction {
            
            if ($wallet->has_autopay && $wallet->is_autopay_changed) {

                    do_insert_into_table(PPC(cid => $wallet->autopay->id), 'autopay_settings', 
            	                      {map {$_ => $wallet->autopay->get_db_column_value('autopay_settings', $_, default_is_ok => 1)} @columns},
                                   on_duplicate_key_update => 1, key => 'wallet_cid');

            }
            if ($wallet->is_autopay_mode_changed) {
                do_update_table(PPC(cid => $wallet->id), 'wallet_campaigns', {autopay_mode => $wallet->autopay_mode}, where=>{wallet_cid => $wallet->id});
            }
        };
    }

    return;
}

=head2 delete_autopay
    
    Удаляет запись в таблице autopay_settings, требуется, к примеру, при отвязке карты.

=cut
sub delete_autopay {
    my ($self) = @_;
    do_in_transaction {        
        do_delete_from_table(PPC(cid => [map {$_->id} @{$self->items}]), 'autopay_settings', where => {wallet_cid => SHARD_IDS});
        do_update_table(PPC(cid => [map {$_->id} @{$self->items}]), 'wallet_campaigns', {autopay_mode => 'none'}, where => {wallet_cid => SHARD_IDS});
    };
    return;
}
1;
