package Direct::Monitor::Base;

=head1 NAME

    Monitor::Base - базовый пакет для вычислений величин, необходимых для мониторингов

=head1 DESCRIPTION

    Определяет один аттрибут :Monitor
    Функция, определённая с таким аттрибутом должна выдавать результат в виде
    {
       название.мониторинга => { value => XXX, desc => 'XXXXXX' },
        ...
    }

=cut

use strict;
use warnings;

use Attribute::Handlers;

our @SUBS;

sub Monitor :ATTR(CHECK) {
    my ($package, $symbol, $referent) = @_;
    push @SUBS, {
        name => *{$symbol}{NAME},
        code => $referent
    };
}

1;
