package Direct::PreloadManifest;
use strict;
use warnings;
use feature qw(state);

=head1 NAME

Direct::PreloadManifest

=head1 DESCRIPTION

Загружает файл, в котором описано соответствие между адресом страниицы в новом директе и ресурсами (js, css),
необходимыми для отрисовки данной страницы

=cut

use Yandex::LiveFile::JSON;
use Settings;

my $DNA_PRELOAD_MANIFEST_PATH = "$Settings::DNA_ROOT/build";

=head1 SUBROUTINES/METHODS

=head2 get_preload_manifest

=cut

sub get_preload_manifest {
    my (%opt) = @_;
    my $exp = $opt{exp} // '';
    my $lang = $opt{lang} // 'ru';
    my $type = $opt{type} // 'desktop';

    my $file_name = $exp eq '' ? 'preload-manifest' : $exp.'_preload-manifest';
    my $file_path = "$DNA_PRELOAD_MANIFEST_PATH/$file_name.$type.$lang.json";

    return {} unless -f $file_path;

    state $preload_manifests = {};

    $preload_manifests->{$file_path} //= Yandex::LiveFile::JSON->new(filename => $file_path);

    return $preload_manifests->{$file_path}->data();
}

1;
