package Direct::ReShard::Process;

use strict;
use warnings;
use utf8;

use parent qw/Exporter/;
our @EXPORT = qw/
    $MAX_RUN_TIME
    $MAX_STARTED_TASKS
    
    $BLOCK_SLEEP
    $BLOCK_SHARD_SLEEP
    
    $ITERATION_INTERVAL
    $MONITOR_INTERVAL
    $VALIDATE_DB_SCHEMA
    $VALIDATE_DB_COLS
    $TRANSACTION_PER_TABLE
/;

# константы для ppcReSharder
our $MAX_RUN_TIME       //= 3600;
our $MAX_STARTED_TASKS  //= 20;

our $BLOCK_SLEEP        //= 600;
our $BLOCK_SHARD_SLEEP  //= 60;

our $ITERATION_INTERVAL //= 10;

our $VALIDATE_DB_SCHEMA //= 1;
our $VALIDATE_DB_COLS   //= 1;
our $TRANSACTION_PER_TABLE //= 1;

1;
