package Direct::Role::Copyable;

use Direct::Modern;
use Mouse::Role;
use Yandex::DBShards;
use Settings;
use JavaIntapi::GenerateObjectIds;
use Carp;

requires qw/copy_extra/;

=head2 copy($get_by_args, $from_client_id, $to_client_id, $mapper_sub, %options)

Роль объекта Direct::..s если объект можно скопировать между разными кампаниями (и клиентами)
Объект поддерживающий роль должен реализовать функцию copy_extra() 

Параметры:
    $get_by_args - параметры выборки (массив []), аналогичные get_by(), [adgroup_id => [1,2,3], filter => 500]
    $from_client_id - ClientID от какого копируются объекты
    $to_client_id - ClientID кому копируются объекты
    $mapper_sub - ссылка на функцию для маппинга значений модели.
                    sub {
                        my $src_object = shift;
                        return $dst_object
                    }
                    Принимает копируемый объект, должна вернуть скопированный объект

    %options:
        primary_key - PK для которого выдать новые id
        остальные параметры прозрачно передаются в copy_extra

=cut

sub copy {
    my ($class, $get_by_args, $from_client_id, $to_client_id, $mapper_sub, %options) = @_;

    my $src_items = $class->get_by(@$get_by_args);
    return {} unless @{$src_items->items}; 

    croak 'unknown primary key ' . ($options{primary_key} // '') unless exists $Yandex::DBShards::SHARD_KEYS{$options{primary_key}}; 
    my $is_sharded = $Yandex::DBShards::SHARD_KEYS{$options{primary_key}}->{chain_key};
    my %generate_ids_params = (
        signature => $options{primary_key},
        count => scalar @{$src_items->items},
    );
    $generate_ids_params{client_id} = $to_client_id if $is_sharded;

    my $ids = JavaIntapi::GenerateObjectIds->new(%generate_ids_params)->call();
    my (%src_id2dst_id, @new_items);
    for my $item (@{$src_items->items}) {
        my $new_item = $mapper_sub->($item->clone);
        $new_item->id(shift @$ids);
        $src_id2dst_id{$item->id} = $new_item->id; 
        push @new_items, $new_item;
    }

    my $dst_items = $class->new(\@new_items);
    $dst_items->prepare_logging('copy');
    $class->manager_class->new(items => $dst_items->items)->create(); 
    $dst_items->do_logging();

    return $class->copy_extra(
        $from_client_id => $src_items, 
        $to_client_id => $dst_items,
        \%src_id2dst_id,
        map { $_ => $options{$_} } grep { $_ !~ /^(primary_key)$/ } keys %options
    );
}

1;
