package Direct::Role::ValidationResultConsumer;

use Direct::Modern;
use Mouse::Role;

use Carp qw/croak/;

use Direct::ValidationResult;
use Direct::Validation::Errors;

has 'validation_result' => (
    is  => 'rw',
    isa => 'Direct::ValidationResult',
    lazy_build      => 1,
    predicate => 'has_validation_result',
);

has 'errors' => (
        is => 'ro',
        isa => 'ArrayRef[Str]',
        lazy => 1,
        default => sub { [] }
);

=head2 is_valid

=cut

sub is_valid {
    my ($self) = @_;

    $self->validate() unless $self->has_validation_result;
    
    return 0 if @{$self->errors};
    
    return $self->validation_result->is_valid;
}

=head2 validate

=cut

sub validate {
    my ($self) = @_;

    # Если есть общие ошибки, то дальше не валидируем
    if (@{$self->errors}) {
        $self->validation_result(Direct::ValidationResult->new());
        # for my $error (@{$self->errors}) {
        #     $self->validation_result->add_generic(error_Unknown($error));
        # }
        return $self;
    }

    return $self->_validate();
}

sub _validate {
    my ($self) = @_;

    croak 'Must be overrided!';
    
#   return $self;
}

sub _add_error {
    my ($self, $error_text, $data) = @_;
            
    push @{$self->errors}, $error_text;
    return;
}

sub _build_validation_result {
    return  Direct::ValidationResult->new();
}

1;
