package Direct::SitelinksSets;

use Direct::Modern;

use base qw/Exporter/;
our @EXPORT_OK = qw/
    link_unlink_sitelinks_sets_to_banners
/;

=head2 link_unlink_sitelinks_sets_to_banners($banners)

=cut

sub link_unlink_sitelinks_sets_to_banners {
    my ($banners) = @_;

    for my $banner (@$banners) {
        $banner->do_refresh_metrika_counters(1) if $banner->is_sitelinks_set_id_changed;
        
        if ($banner->status_moderate eq 'New') {
            # Баннер является черновиком
            $banner->sitelinks_status_moderate('New');
            if ($banner->does_role('Update') && $banner->has_old && $banner->old->sitelinks_status_moderate ne 'New') {
                # Если сайтлинк-сет не был черновиком, то нужно удалить его из модерации
                $banner->do_delete_sitelinks_set_from_moderation(1);
            }
            next;
        }

        if ($banner->sitelinks_set_id) {
            # TOOD: Возможно, следует использовать ModerateChecks::check_moderate_sitelinks
            my $need_moderate_sitelinks   = $banner->is_sitelinks_set_id_changed;
               $need_moderate_sitelinks ||= $banner->has_sitelinks_status_moderate && $banner->sitelinks_status_moderate eq 'No';

            # Привязали новые сайтлинки или (пере)отправили баннер на модерацию
            $banner->sitelinks_status_moderate('Ready') if $need_moderate_sitelinks || $banner->status_moderate eq 'Ready';
        } else {
            # Сайтлинки отвязываются от баннера --
            #   выставим статус модерации сайтлинков в состояние по умолчанию и уберем из модерации
            $banner->sitelinks_status_moderate('New');
            $banner->do_delete_sitelinks_set_from_moderation(1) if $banner->is_sitelinks_set_id_changed;
        }
        
        $banner->status_bs_synced('No') if $banner->is_sitelinks_set_id_changed;
    }

    return $banners;
}

1;
