package Direct::Storage::File;

=head2 DESCRIPTION

Объект-файл из хранилища

Поля:
size - размер файла
ClientID
type - тип файла, должен быть перечислен с ppc.mds_metadata.type
create_time - дата создания
filename - имя файла
content - содержимое файла, заполняется лениво при первом обращении
url - url файла в хранилище

=head1 INTERNAL

Пояснение про _storage_host:
Это поле нужно для ситуации, когда на ТС (или бете) есть записи о файле,
который на самом деле хранится в продакшн хранилище. При сохранении мы
записываем get host, с которого можно получить этот файл

=cut

use strict;
use warnings;
use utf8;
use Carp;
use Yandex::HTTP qw/http_fetch/;

use base qw/Class::Accessor/;
Direct::Storage::File->mk_accessors(qw/
    _id
    _mds_key
    _mds
    _storage_host
    size
    ClientID
    type
    create_time
    filename
/);

=head2 url

получить URL файла в МДС

=cut

sub url
{
    my ($self) = @_;
    return $self->_mds->make_url(get => $self->_mds_key, host => $self->_storage_host);
}

=head2 internal_redirect_url

URL, который можно отдать nginx в X-Accel-Redirect, чтобы он сам сходил в MDS за файлом и отдал
результат клиенту

=cut

sub internal_redirect_url {
    my ( $self, %http_headers ) = @_;

    my $url = '/serve_mds_file/' . ( $self->_storage_host || $self->_mds->get_host ) . '/' . $self->_mds_key;

    ## намеренно не используем здесь URI, который эскейпит символы, потому что nginx
    ## в переменных $arg_* из потом оставляет заэскейпленными, а нам такого не надо
    my @query;
    for my $header ( sort keys %http_headers ) {
        push @query, ( lc $header =~ s/-/_/gr ) . '=' . $http_headers{$header};
    }

    if (@query) {
        $url .= '?' . join( '&', @query );
    }

    return $url;
}

=head2 content

Лениво получить содержимое файла из МДС

=cut

sub content
{
    my $self = shift;
    if (@_) {
        croak "content is read only"
    }

    if (defined $self->{content}) {
        return $self->{content};
    }

    return $self->{content} = http_fetch(GET => $self->url, undef, num_attempts => 3);
}

1;

