package Direct::Strategy::AutobudgetAvgClick;
use Direct::Modern;
use Mouse;
#use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has avg_bid => ( is => 'rw', isa => 'Maybe[Num]' );
has sum => ( is => 'rw', isa => 'Maybe[Num]' );


override name => sub { "autobudget_avg_click" };
override title => sub { iget_noop("Средняя цена клика (за неделю)") };

override supporded_campaign_types => sub {[ qw/text mobile_content dynamic content_promotion/ ]};
override get_params_list => sub {[qw/ avg_bid sum /]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        avg_bid => $self->_as_num($self->avg_bid),
        sum => $self->_as_num($self->sum),
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_avg_bid} = $self->avg_bid;
    $hash->{autobudget_sum} = $self->sum;

    return $hash;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        avg_bid => [$self->avg_bid, sum => $self->sum, required => 1],
        sum     => [$self->sum],
    ];
};


__PACKAGE__->meta->make_immutable;
1;
