package Direct::Strategy::AutobudgetAvgCpaPerCamp;
use Direct::Modern;
use Mouse;
#use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has pay_for_conversion => ( is => 'rw', isa => 'Maybe[Bool]' );
has goal_id => ( is => 'rw', isa => 'Maybe[Int]' );
has last_bidder_restart_time => ( is => 'rw', isa => 'Maybe[Str]' );
has avg_cpa => ( is => 'rw', isa => 'Maybe[Num]' );
has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has bid => ( is => 'rw', isa => 'Maybe[Num]' );


override name => sub { "autobudget_avg_cpa_per_camp" };
override title => sub { iget_noop("Оптимизация средней цены конверсии по всей кампании") };

override supporded_campaign_types => sub {[ qw/performance/ ]};
override get_params_list => sub {[qw/ goal_id sum bid avg_cpa pay_for_conversion/]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        avg_cpa => $self->_as_num($self->avg_cpa),
        last_bidder_restart_time  => $self->last_bidder_restart_time,
        goal_id => $self->_as_str($self->goal_id),
        sum => $self->_as_num($self->sum),
        bid => $self->_as_num($self->bid),
        pay_for_conversion => $self->_as_num($self->pay_for_conversion),
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_pay_for_conversion} = $self->pay_for_conversion;
    $hash->{autobudget_goal_id} = $self->goal_id;
    $hash->{autobudget_avg_cpa} = $self->avg_cpa;
    $hash->{last_bidder_restart_time}  = $self->last_bidder_restart_time;
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_bid} = $self->bid;

    return $hash;
};


override set_camp_values => sub {
    my $self = shift;
    my ($camp) = @_;

    super();
    $camp->_strategy_name($self->name);
    return;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        sum     => [$self->sum],
        bid     => [$self->bid, sum => $self->sum],
        avg_cpa => [$self->avg_cpa, sum => $self->sum, required => 1],
        goal_id => [$self->goal_id, required => 1],
        pay_for_conversion => [$self->pay_for_conversion, avg_cpa => $self->avg_cpa, goal_id => $self->goal_id ],
    ];
};


__PACKAGE__->meta->make_immutable;
1;

