package Direct::Strategy::AutobudgetAvgCpcPerCamp;
use Direct::Modern;
use Mouse;
# use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has avg_bid => ( is => 'rw', isa => 'Maybe[Num]' );
has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has bid => ( is => 'rw', isa => 'Maybe[Num]' );


override name => sub { "autobudget_avg_cpc_per_camp" };
override title => sub { iget_noop("Оптимизация средней цены клика по всей кампании") };

override supporded_campaign_types => sub {[ qw/performance mcbanner content_promotion/ ]};
override get_params_list => sub {[qw/ sum bid avg_bid /]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        avg_bid => $self->_as_num($self->avg_bid),
        sum => $self->_as_num($self->sum),
        bid => $self->_as_num($self->bid),
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_avg_bid} = $self->avg_bid;
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_bid} = $self->bid;

    return $hash;
};


override set_camp_values => sub {
    my $self = shift;
    my ($camp) = @_;

    super();
    $camp->_strategy_name($self->name);
    return;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        sum     => [$self->sum],
        bid     => [$self->bid, sum => $self->sum],
        avg_bid => [$self->avg_bid, sum => $self->sum, required => 1],
    ];
};


__PACKAGE__->meta->make_immutable;
1;
