package Direct::Strategy::AutobudgetAvgCpi;
use Direct::Modern;
use Mouse;
use Settings;
#use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has pay_for_conversion => ( is => 'rw', isa => 'Maybe[Bool]' );
has last_bidder_restart_time => ( is => 'rw', isa => 'Maybe[Str]' );
has avg_cpi => ( is => 'rw', isa => 'Maybe[Num]' );
has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has bid => ( is => 'rw', isa => 'Maybe[Num]' );
has goal_id => ( is => 'rw', isa => 'Maybe[Int]', default => $Settings::DEFAULT_CPI_GOAL_ID );

override _filter_strategy_data_for_json => sub {
    my $self = shift;

    my $save_data = super();

    if (defined $save_data->{goal_id} && $save_data->{goal_id} == $Settings::DEFAULT_CPI_GOAL_ID) {
        delete $save_data->{goal_id};
    }
    return $save_data;
};

override name => sub { "autobudget_avg_cpi" };
override title => sub { iget_noop("Средняя цена установки") };

override supporded_campaign_types => sub {[ qw/mobile_content/ ]};
override get_params_list => sub {[qw/ sum bid avg_cpi goal_id pay_for_conversion/]};


override _get_attrs_from_campaign_hash => sub {
    my $self = shift;
    my ($camp) = @_;

    my $attr = super();

    $attr->{avg_cpi} = $attr->{avg_cpa};
    return $attr;
};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        avg_cpi => $self->_as_num($self->avg_cpi),
        sum => $self->_as_num($self->sum),
        bid => $self->_as_num($self->bid),
        goal_id => $self->_as_str($self->goal_id),
        last_bidder_restart_time  => $self->last_bidder_restart_time,
        pay_for_conversion => $self->_as_num($self->pay_for_conversion),
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_pay_for_conversion} = $self->pay_for_conversion;
    $hash->{autobudget_avg_cpi} = $self->avg_cpi;
    $hash->{last_bidder_restart_time} = $self->last_bidder_restart_time;
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_bid} = $self->bid;
    $hash->{autobudget_goal_id} = $self->goal_id;

    return $hash;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        avg_cpi => [$self->avg_cpi, sum => $self->sum, required => 1],
        goal_id => [$self->goal_id],
        sum     => [$self->sum],
        bid     => [$self->bid, sum => $self->sum],
        pay_for_conversion => [$self->pay_for_conversion, avg_cpi => $self->avg_cpi, sum => $self->sum, goal_id => $self->goal_id ],
    ];
};


__PACKAGE__->meta->make_immutable;
1;

