package Direct::Strategy::AutobudgetAvgCpvBase;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has pay_for_conversion => ( is => 'ro', isa => 'Maybe[Bool]' );
has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has avg_cpv => ( is => 'rw', isa => 'Maybe[Num]' );

override supporded_campaign_types => sub {[ qw/cpm_banner cpm_deals/ ]};
override get_params_list => sub {[ qw/sum avg_cpv pay_for_conversion/ ]};

override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        sum => $self->_as_num($self->sum),
        avg_cpv => $self->_as_num($self->avg_cpv),
        pay_for_conversion => $self->_as_num($self->pay_for_conversion),
    };
};

override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_avg_cpv} = $self->avg_cpv;
    $hash->{autobudget_pay_for_conversion} = $self->pay_for_conversion;

    return $hash;
};

override set_camp_values => sub {
    my $self = shift;
    my ($camp) = @_;

    super();
    $camp->_strategy_name('different_places');
    $camp->strategy_name($self->name);
    return;
};

override get_fields_to_check => sub {
    my $self = shift;

    return [
        sum     => [$self->sum, required => 1],
        avg_cpv => [$self->avg_cpv, sum => $self->sum, required => 1],
        # Здесь avg_cpa, чтобы проходило валидацию
        pay_for_conversion => [$self->pay_for_conversion, avg_cpa => $self->avg_cpv, sum => $self->sum],

    ];
};

__PACKAGE__->meta->make_immutable;
1;
