package Direct::Strategy::AutobudgetAvgCpvCustomPeriodBase;
use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy::AutobudgetAvgCpvBase';

has start  => ( is => 'rw', isa => 'Maybe[Str]' );
has finish => ( is => 'rw', isa => 'Maybe[Str]' );
has budget => ( is => 'rw', isa => 'Maybe[Num]' );
has auto_prolongation => ( is => 'rw', isa => 'Maybe[Bool]' );
has last_update_time => ( is => 'rw', isa => 'Maybe[Str]' );
has daily_change_count => ( is => 'rw', isa => 'Maybe[Num]' );
has '+sum' => (isa => 'Undef', builder => sub { undef });

override get_params_list => sub {[ qw/budget avg_cpv start finish auto_prolongation pay_for_conversion/ ]};

override get_strategy_hash => sub {
        my $self = shift;

        return {
            name => $self->name,
            avg_cpv => $self->_as_num($self->avg_cpv),
            pay_for_conversion => $self->_as_num($self->pay_for_conversion),
            budget => $self->_as_num($self->budget),
            start => $self->start,
            finish => $self->finish,
            last_update_time => $self->last_update_time,
            daily_change_count => $self->daily_change_count,
            auto_prolongation => $self->_as_num($self->auto_prolongation),
        };
    };

override get_flat_strategy_hash => sub {
        my $self = shift;

        my $hash = super();
        delete $hash->{autobudget_sum};
        $hash->{budget} = $self->budget;
        $hash->{start} = $self->start;
        $hash->{finish} = $self->finish;
        $hash->{last_update_time} = $self->last_update_time;
        $hash->{daily_change_count} = $self->daily_change_count;
        $hash->{auto_prolongation} = $self->auto_prolongation;
        $hash->{autobudget_pay_for_conversion} = $self->pay_for_conversion;

        return $hash;
    };

override get_fields_to_check => sub {
        my $self = shift;

        return [
            budget  => [$self->budget, required => 1],
            avg_cpv => [$self->avg_cpv, sum => $self->budget, required => 1],
            start   => [$self->start, required => 1],
            finish  => [$self->finish, required => 1],
            # Здесь avg_cpa, чтобы проходило валидацию
            pay_for_conversion => [$self->pay_for_conversion, avg_cpa => $self->avg_cpv, sum => $self->budget,],
        ];
    };

__PACKAGE__->meta->make_immutable;
1;
