package Direct::Strategy::AutobudgetCpmBase;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has avg_cpm => ( is => 'rw', isa => 'Maybe[Num]' );

override supporded_campaign_types => sub {[ qw/cpm_banner cpm_deals cpm_yndx_frontpage/ ]};
override get_params_list => sub {[ qw/sum avg_cpm/ ]};

override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        sum => $self->_as_num($self->sum),
        avg_cpm => $self->_as_num($self->avg_cpm),
    };
};

override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_avg_cpm} = $self->avg_cpm;

    return $hash;
};

override set_camp_values => sub {
    my $self = shift;
    my ($camp) = @_;

    super();
    $camp->_strategy_name('different_places');
    $camp->strategy_name($self->name);
    return;
};

override get_fields_to_check => sub {
    my $self = shift;

    return [
        sum     => [$self->sum, required => 1],
        avg_cpm => [$self->avg_cpm, sum => $self->sum, required => 1],
    ];
};

__PACKAGE__->meta->make_immutable;
1;

