package Direct::Strategy::AutobudgetCrr;

use Direct::Modern;
use Mouse;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has goal_id => ( is => 'rw', isa => 'Maybe[Int]' );
has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has crr => ( is => 'rw', isa => 'Maybe[Int]' );
has last_bidder_restart_time => ( is => 'rw', isa => 'Maybe[Str]' );
has pay_for_conversion => ( is => 'rw', isa => 'Maybe[Bool]' );

override name => sub { "autobudget_crr" };
override title => sub { iget_noop("Доля рекламных расходов") };

override supporded_campaign_types => sub {[ qw/text dynamic performance/ ]};
override get_params_list => sub {[qw/ sum goal_id crr pay_for_conversion /]};

override get_strategy_hash => sub {
    my $self = shift;

    return {
        name    => $self->name,
        goal_id => $self->_as_str($self->goal_id),
        sum     => $self->_as_num($self->sum),
        crr     => $self->_as_num($self->crr),
        last_bidder_restart_time  => $self->last_bidder_restart_time,
        pay_for_conversion => $self->_as_num($self->pay_for_conversion)
    }
};

override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_goal_id} = $self->goal_id;
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_crr} = $self->crr;
    $hash->{last_bidder_restart_time} = $self->last_bidder_restart_time;
    $hash->{autobudget_pay_for_conversion} = $self->pay_for_conversion;

    return $hash;
};

override get_fields_to_check => sub {
    my $self = shift;

    return [
        sum => [$self->sum],
        crr => [$self->crr, required => 1],
        goal_id => [$self->goal_id, required => 1],
    ];
};

__PACKAGE__->meta->make_immutable;
1;
