package Direct::Strategy::AutobudgetMedia;
use Direct::Modern;
use Mouse;
#use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has date => ( is => 'rw', isa => 'Str' );


override name => sub { "autobudget_media" };
override title => sub { iget_noop("Автобюджет") };

override supporded_campaign_types => sub {[ qw/mcb/ ]};
override get_params_list => sub {[qw/ date /]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => 'autobudget',
        date => $self->date,
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_date} = $self->date;

    return $hash;
};


override set_camp_values => sub {
    my $self = shift;
    my ($camp) = @_;

    super();
    $camp->_autobudget_date($self->date);
    return;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        date    => [$self->date, required => 1],
    ];
};


__PACKAGE__->meta->make_immutable;
1;

