package Direct::Strategy::AutobudgetRoi;
use Direct::Modern;
use Mouse;
#use namespace::autoclean;

use Yandex::I18n;
use Yandex::HashUtils;
use JSON;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';


has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has goal_id => ( is => 'rw', isa => 'Maybe[Int]' );
has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has bid => ( is => 'rw', isa => 'Maybe[Num]' );
has roi_coef => ( is => 'rw', isa => 'Maybe[Num]' );
has reserve_return => ( is => 'rw', isa => 'Maybe[Num]' );
has profitability => ( is => 'rw', isa => 'Maybe[Num]' );


override name => sub { "autobudget_roi" };
override title => sub { iget_noop("Рентабельность рекламы") };

override supporded_campaign_types => sub {[ qw/text dynamic performance/ ]};
override get_params_list => sub {[qw/ sum bid goal_id roi_coef reserve_return profitability /]};


override _get_attrs_from_campaign_hash => sub {
    my $self = shift;
    my ($camp) = @_;

    my $attr = super();
    hash_copy $attr, $camp, qw/goal_id/;

    if (my $roi_params_json = delete $attr->{roi_params}) {
        my $roi_params = from_json $roi_params_json;
        hash_copy $attr, $roi_params, qw/ reserve_return profitability /;
    }

    return $attr;
};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        goal_id => $self->_as_str($self->goal_id),
        sum => $self->_as_num($self->sum),
        bid => $self->_as_num($self->bid),
        roi_coef => $self->_as_num($self->roi_coef),
        reserve_return => $self->_as_num($self->reserve_return),
        profitability => $self->_as_num($self->profitability),
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_goal_id} = $self->goal_id;
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_bid} = $self->bid;
    $hash->{autobudget_roi_coef} = $self->roi_coef;
    $hash->{autobudget_reserve_return} = $self->reserve_return;
    $hash->{autobudget_profitability} = $self->profitability;

    return $hash;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        sum     => [$self->sum],
        bid     => [$self->bid, sum => $self->sum],
        roi_coef => [$self->roi_coef, required => 1],
        reserve_return => [$self->reserve_return, required => 1],
        profitability => [$self->profitability],
        goal_id => [$self->goal_id, required => 1],
    ];
};


__PACKAGE__->meta->make_immutable;
1;
