package Direct::Strategy::AutobudgetWeekBundle;
use Direct::Modern;
use Mouse;
#use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has limit_clicks => ( is => 'rw', isa => 'Maybe[Num]' );
has avg_bid => ( is => 'rw', isa => 'Maybe[Num]' );
has bid => ( is => 'rw', isa => 'Maybe[Num]' );


override name => sub { "autobudget_week_bundle" };
override title => sub { iget_noop("Недельный пакет кликов") };

override supporded_campaign_types => sub {[ qw/text mobile_content dynamic content_promotion/ ]};
override get_params_list => sub {[qw/ limit_clicks avg_bid bid /]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        limit_clicks => $self->_as_num($self->limit_clicks),
        avg_bid => $self->_as_num($self->avg_bid),
        bid => $self->_as_num($self->bid),
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_limit_clicks} = $self->limit_clicks;
    $hash->{autobudget_avg_bid} = $self->avg_bid;
    $hash->{autobudget_bid} = $self->bid;

    return $hash;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        limit_clicks => [$self->limit_clicks, required => 1],
        bid => [$self->bid],
        avg_bid => [$self->avg_bid, bid => $self->bid],
    ];
};


__PACKAGE__->meta->make_immutable;
1;

