package Direct::Strategy::AutobudgetWeekSum;
use Direct::Modern;
use Mouse;
#use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 1, init_arg => undef );

has sum => ( is => 'rw', isa => 'Maybe[Num]' );
has bid => ( is => 'rw', isa => 'Maybe[Num]' );
has goal_id => ( is => 'rw', isa => 'Maybe[Int]' );
has last_bidder_restart_time => ( is => 'rw', isa => 'Maybe[Str]' );

override name => sub { "autobudget" };
override title => sub { iget_noop("Недельный бюджет") };

override supporded_campaign_types => sub {[ qw/text mobile_content dynamic content_promotion/ ]};
override get_params_list => sub {[qw/ sum bid goal_id /]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        sum => $self->_as_num($self->sum),
        bid => $self->_as_num($self->bid),
        goal_id => $self->_as_str($self->goal_id),
        last_bidder_restart_time  => $self->last_bidder_restart_time,
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{autobudget_sum} = $self->sum;
    $hash->{autobudget_bid} = $self->bid;
    $hash->{autobudget_goal_id} = $self->goal_id;
    $hash->{last_bidder_restart_time}  = $self->last_bidder_restart_time;

    return $hash;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        sum     => [$self->sum, required => 1],
        bid     => [$self->bid, sum => $self->sum],
        goal_id => [$self->goal_id],
    ];
};


__PACKAGE__->meta->make_immutable;
1;

