package Direct::Strategy::CpmDefault;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 0, init_arg => undef );


override name => sub { "cpm_default" };
override title => sub { iget_noop("Ручное управление ставками") };

override supporded_campaign_types => sub {[ qw/cpm_banner cpm_deals cpm_yndx_frontpage cpm_price/ ]};
override get_params_list => sub {[ ]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
    };
};


override get_fields_to_check => sub {
    my $self = shift;

    return [];
};

override set_camp_values => sub {
    my $self = shift;
    my ($camp) = @_;

    super();
    $camp->_strategy_name('different_places');
    $camp->strategy_name($self->name);
    return;
};

__PACKAGE__->meta->make_immutable;
1;

