package Direct::Strategy::NoPremium;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;
#use namespace::autoclean;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

has '+is_autobudget' => ( is => 'ro', default => 0, init_arg => undef );

has place => ( is => 'rw', isa => enum([qw/highest_place/]) );

override name => sub { "no_premium" };
override title => sub { iget_noop("Показ под результатами поиска") };
override title_expanded => sub { +{
        name => iget_noop("Показ под результатами поиска"),
        highest_place => iget_noop('Показ под результатами поиска на наивысшей доступной позиции'),
    }};

override supporded_campaign_types => sub {[ qw/text mobile_content dynamic/ ]};
override get_params_list => sub {[qw/ place /]};


override _get_attrs_from_campaign_hash => sub {
    my $self = shift;
    my ($camp) = @_;

    my $attr = super();
    $attr->{place} = 'highest_place'; # $camp->{strategy_no_premium};

    return $attr;
};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        place => $self->place,
    };
};


override get_flat_strategy_hash => sub {
    my $self = shift;

    my $hash = super();
    $hash->{strategy_no_premium} = $self->place;

    return $hash;
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
#        place => [$self->place],
    ];
};


__PACKAGE__->meta->make_immutable;
1;

