package Direct::Strategy::PeriodFixBid;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;

use Direct::Validation::Strategy;

extends 'Direct::Strategy';

#В Директе стратегия ручная, ставка фиксированная и выставляется на условиях показа. В БК отправляется с флагом AutoBudget = 1
has '+is_autobudget' => ( is => 'ro', default => 0, init_arg => undef );

has start  => ( is => 'rw', isa => 'Str' );
has finish => ( is => 'rw', isa => 'Str' );
has budget => ( is => 'rw', isa => 'Num' );
has auto_prolongation => ( is => 'rw', isa => 'Maybe[Bool]' );


override name => sub { "period_fix_bid" };
override title => sub { iget_noop("Фиксированная ставка на периоде") };

override supporded_campaign_types => sub {[ qw/cpm_price/ ]};
override get_params_list => sub {[ qw/budget start finish auto_prolongation/ ]};


override get_strategy_hash => sub {
    my $self = shift;

    return {
        name => $self->name,
        budget => $self->_as_num($self->budget),
        start => $self->start,
        finish => $self->finish,
        auto_prolongation => $self->_as_num($self->auto_prolongation),
    };
};


override get_fields_to_check => sub {
    my $self = shift;

    return [
        budget  => [$self->budget, required => 1],
        start   => [$self->start, required => 1],
        finish  => [$self->finish, required => 1],
    ];
};

override set_camp_values => sub {
    my $self = shift;
    my ($camp) = @_;

    super();
    $camp->_strategy_name('different_places');
    $camp->strategy_name($self->name);
    return;
};

__PACKAGE__->meta->make_immutable;
1;

