package Direct::TargetInterests;

use Mouse;

use Direct::Modern;

use Settings;

use Direct::Model::Retargeting;
use Direct::RetargetingConditions;
use Direct::TargetingCategories;

use Yandex::I18n;
use List::MoreUtils qw/any uniq/;

extends 'Direct::Retargetings';

has '+items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::TargetInterest]');

=head2 manager_class
=head2 manager
=cut

sub manager { $_[0]->manager_class->new(items => $_[0]->items) }

sub get_by {
    my ($class, $key, $vals, %options) = @_;

    return $class->SUPER::get_by($key, $vals, %options, type => ['interest']);
}

before 'create' => \&prepare_ret_cond_id;
before 'update' => \&prepare_ret_cond_id;

=head2 prepare_ret_cond_id

Т.к. интересы фактически это просто цель в RetargetingCondition, то необходимо преобразовать
target_category_id в соответствующий RetargetingCondition

=cut

sub prepare_ret_cond_id {
    my ($self) = @_;

    my $target_category_by_id = Direct::TargetingCategories->get_rmp_interests->items_by;

    my %goal_id2ret_cond;

    for my $ret_cond (@{ Direct::RetargetingConditions->get_by( client_id => [ uniq map {$_->adgroup->client_id} @{ $self->items } ], type => ['interest'] )->items }) {
        for my $cond (@{ $ret_cond->condition }) {
            for my $goal (@{ $cond->goals }) {
                $goal_id2ret_cond{$goal->goal_id} = $ret_cond;
            }
        }
    }

    for my $item (@{ $self->items }) {
        my $goal_id = $target_category_by_id->{$item->target_category_id}->import_id;
        next if exists $goal_id2ret_cond{$goal_id};

        $goal_id2ret_cond{$goal_id} = Direct::Model::RetargetingCondition->new(
            id         => 0,
            client_id  => $item->adgroup->client_id,
            properties => 'interest',
            retargeting_conditions_type => 'metrika_goals',
            condition  => [
                Direct::Model::RetargetingCondition::Rule->new( type => 'all', goals => [ Direct::Model::RetargetingCondition::Goal->new( goal_id => $goal_id, time => 90 ), ] ),
            ],
        );
    }

    Direct::RetargetingConditions->new( [ grep {!$_->id} values %goal_id2ret_cond ] )->create;
    for my $item (@{ $self->items }) {
        $item->ret_cond_id( $goal_id2ret_cond{$target_category_by_id->{$item->target_category_id}->import_id}->id );
    }
}

1;
