=head1 NAME

    Direct::Template

=head1 DESCRIPTION

    Работа с шаблонизатором

=cut

package Direct::Template;

use warnings;
use strict;
use feature qw/state/;

require Exporter;

use base qw(Exporter);
our @EXPORT = qw(
);


use Cwd qw/realpath/;
use Encode qw/decode decode_utf8 encode_utf8/;
use File::Slurp;
use JavaScript::V8;
use JSON;
use POSIX qw(strftime floor ceil);
use Try::Tiny;
use URI::Escape qw/uri_escape_utf8 uri_unescape/;
use MIME::Base64 qw/encode_base64/;

use Yandex::HTTP qw/http_get http_parallel_request/;
use Yandex::HashUtils;
use Yandex::I18n;
use Yandex::LiveFile;
use Yandex::Log;
use Yandex::Trace;

use Settings;

use Direct::StaticFilesHash;
use Direct::GlobalVars;
use Direct::InlineScript;
use Direct::PreloadManifest;
use BannerFlags;
use Client::ClientFeatures;
use Currencies;
use Currency::Format;
use Currency::Texts;
use Currency::Rate;
use GeoTools;
use TTTools;
use EnvTools;
use TextTools;
use Tools;
use RBACDirect qw/rbac_role_name/;
use VarsSchema;
use InterfaceConsts;
use Template::Plugin::DocsL10n;
use MTools qw//;
use ModerateDiagnosis qw//;

#use Direct::Template::Logger::Context;
#use Direct::Template::Logger::Stash;

our $JS_CTX;
our %JS_CACHE;
our %BEM;

our $EXTERNAL_TEMPLATING_URL;
# "белый список" контроллеров, которые шаблонизируются через внешний шаблонизатор
our $EXTERNAL_TEMPLATING_CMDS = { map {$_ => 1} qw(
    showSearchPage
    search
    agSearch
    showCamps
    showCamp
    gobackMultiEdit
    bannersMultiSave
    showCampMultiEdit
    addBannerMultiEdit
    showCampMultiEditLight
    )
};

our $DEFAULT_SOURCE = 'data3';
our %BUNDLE_FILE = (
    data3 => {
        direct => "data3/desktop.bundles/direct/_direct.bemtree.xjst.js",
        direct_touch => "data3/touch.bundles/direct/_direct.bemtree.xjst.js",
        head   => "data3/desktop.bundles/head/_head.bemtree.xjst.js",
    },
);
our $LAST_USED_BUNDLE_FILE = '';

{
my $PRE_DEFINE = undef;

=head2 predefine

    TODO

=cut
sub predefine
{
    $PRE_DEFINE ||= {
        support        => 'support@direct.yandex.ru',
        conv_unit_rate => get_conv_unit_rate(),
        nds            => $Settings::NDS_RU_DEPRECATED,
        help           => 'http://direct.yandex.ru/help/',
        is_beta        => is_beta(),
        is_production  => is_production(),
        DOCUMENT_ROOT  => $ENV{DOCUMENT_ROOT},
        IMAGE_HOST     => $Settings::IMAGE_HOST,
        IMAGE_HOST_FOR_INTERNAL_USAGE => $Settings::IMAGE_HOST_FOR_INTERNAL_USAGE,
        CONFIGURATION  => $Settings::CONFIGURATION,
        AD_WARNINGS    => BannerFlags::get_all_warnings(for_template => 1),
        INTERFACE_LANGS  => \%Settings::INTERFACE_LANGS,
        SKIP_URL_PARAMS => $TTTools::SKIP_URL_PARAMS,

        CONSTS => InterfaceConsts::get_interface_consts(),

        # TODO: избавиться от этих констант. Данные доступны всюду через get_currency_constant
        # использование уешных констант скорее всего означает проблемы с мультивалютностью
        min_price      => get_currency_constant('YND_FIXED', 'MIN_PRICE'),
        MIN_PRICE      => get_currency_constant('YND_FIXED', 'MIN_PRICE'),
        MAX_AUTOBUDGET_BID => get_currency_constant('YND_FIXED', 'MAX_AUTOBUDGET_BID'), # currency_defaults

        # TODO: избавиться от этих констант. Они доступны через более универсальный CONSTS.
        MAX_URL_LENGTH => $MAX_URL_LENGTH,
        SITELINKS_NUMBER => 4,

        # functions
        uri_escape                 => \&uri_escape_utf8,
        string2html                => \&string2html,
        round2s                    => \&round2s,
        floor                      => \&floor,
        ceil                       => \&ceil,
        get_plot_link              => \&TTTools::get_plot_link,
        dumper                     => \&TTTools::dumper,
        get_sort_table_header      => \&TTTools::get_sort_table_header,
        get_sort_table_all_headers => \&TTTools::get_sort_table_all_headers,
        sort_table_data            => \&TTTools::sort_table_data,
        format_price               => \&TTTools::format_price,
        format_units               => \&TTTools::format_units,
        format_int                 => \&TTTools::format_int,
        format_date                => \&TTTools::format_date,
        format_href                => \&TTTools::format_href,
        format_file_size           => \&TTTools::format_file_size,
        rbac_role_name             => \&rbac_role_name,
        get_word_for_digit         => \&get_word_for_digit,
        get_geo_names              => \&GeoTools::get_geo_names,
        get_current_url_params     => \&TTTools::get_current_url_params,
        iget                       => \&iget,
        iget_noop                  => \&iget_noop,
        piget                      => \&piget,
        piget_array                => \&piget_array,
        trim_float                 => \&TTTools::trim_float,
        console_log                => \&TTTools::console_log,
        warn                       => \&TTTools::server_warn,
        json_dump                  => \&TTTools::json_dump,
        truncate                   => \&TextTools::truncate_text,
        is_targeting_in_region     => \&GeoTools::is_targeting_in_region,
        get_doc_path               => \&Template::Plugin::DocsL10n::get_doc_path,
        get_ref                    => sub { ref(shift); },

        # required by lego
        js_quote                   => \&js_quote,
        js_encode                  => \&js_quote,
        url_quote                  => \&url_quote,
        html_escape                => sub { string2html(my $str=shift) },
        generate_id                => \&TTTools::generate_id,
        is_string                  => \&TTTools::is_string,

        hash_copy                  => \&Yandex::HashUtils::hash_copy,

        # функции для работы с валютами. описание см. в Currencies и Currency::Texts
        get_currency_constant      => \&get_currency_constant,
        get_currency_text          => \&get_currency_text,
        format_sum_of_money        => \&format_sum_of_money,
        # conv_unit_explanation($pay_currency)
        conv_unit_explanation      => sub {return conv_unit_explanation('YND_FIXED', @_)},
        format_const               => \&format_const,
        format_currency            => \&format_currency,

        # функции работы с форматами объявлений в Баяне
        media_format_by_id         => \&MTools::media_format_by_id,
        base_media_format          => \&MTools::base_media_format,

        get_file_content           => \&get_file_content,
        get_help_url               => \&Tools::get_help_url,

        # Тексты старых причин отклонений на модерации
        get_old_moderate_diags     => sub { hash_grep { !defined $_->{token} } ModerateDiagnosis::get_diags_hash() },
    };

    if (is_beta()) {
        $PRE_DEFINE->{log} = \&_log_from_template;
    }

    return $PRE_DEFINE;
}
}




{
my $DYNAMIC_PREDEFINE;

=head2 save_dynamic_predefine

    TODO

=cut
sub save_dynamic_predefine
{
    $DYNAMIC_PREDEFINE = shift;
}

=head2 add_dynamic_predefine

    TODO

=cut
sub add_dynamic_predefine
{
    my ($reqid, $new_values) = @_;

    die "incorrect reqid '$reqid'" if !$reqid || $reqid != $DYNAMIC_PREDEFINE->{reqid};

    hash_merge($DYNAMIC_PREDEFINE, $new_values);
}

=head2 dynamic_predefine

    TODO

=cut
sub dynamic_predefine
{
    my ($reqid) = @_;

    die "incorrect reqid '$reqid'" if !$reqid || $reqid != $DYNAMIC_PREDEFINE->{reqid};

    return $DYNAMIC_PREDEFINE;
}

=head2 put_csp_nonce

    TODO

=cut
sub put_csp_nonce {
    my ($reqid) = @_;

    die "incorrect reqid '$reqid'" if !$reqid || $reqid != $DYNAMIC_PREDEFINE->{reqid};

    $DYNAMIC_PREDEFINE->{csp_nonce} = encode_base64(Yandex::Trace::generate_traceid(), "");
}

=head2 get_csp_nonce

    TODO

=cut
sub get_csp_nonce {
    my ($reqid) = @_;
    die "incorrect reqid '$reqid'" if !$reqid || $reqid != $DYNAMIC_PREDEFINE->{reqid};
    return $DYNAMIC_PREDEFINE->{csp_nonce};
}

}

=head2 init_bem

    Работаем с _direct.bemtree.xjst.js, инициализируем функцию в %BEM

=cut

{
=head2 init_bem

    TODO

=cut
sub init_bem
{
    my (%opt) = @_;

    my $source = $opt{source} || $DEFAULT_SOURCE;
    my $bundle = $opt{bundle} || 'direct';

    my $bundle_file = $BUNDLE_FILE{$source}->{$bundle};
    die "init_bem: unsupported combination: bundle='$bundle', source='$source'"  if !$bundle_file;
    $LAST_USED_BUNDLE_FILE = $bundle_file;

    # Если потребуется собрать профиль v8, сделать это можно передав флаги --prof --logfile=/path/to/v8.log
    $JS_CTX ||= JavaScript::V8::Context->new(flags=>"--max-old-space-size=4096");
    my $JS_SOURCE = '';
    my $reeval = 0;
    if (is_beta() && get_bemserver_port()) {
        $JS_SOURCE = query_bemserver($bundle_file, -f "$Settings::LOCK_ROOT/enbserver" ? 'enb' : 'bem');
        $reeval = 1;
    } else {
        my $filename_abs = "$Settings::ROOT/$bundle_file";
        my $filetime = join(":", (stat($filename_abs))[1,7,9]);
        if (!$JS_CACHE{$bundle_file}->{source} || $JS_CACHE{$bundle_file}->{time} ne $filetime) {
            $JS_CACHE{$bundle_file}->{source} = read_file($filename_abs, binmode => ':utf8') or die "can't read $filename_abs";
            $JS_SOURCE = $JS_CACHE{$bundle_file}->{source};
            $JS_CACHE{$bundle_file}->{time} = $filetime;
            $reeval = 1;
        }
    }

    if ($reeval) {
        die "no JS_SOURCE" unless $JS_SOURCE;
        try {
            $BEM{$bundle_file} = $JS_CTX->eval($JS_SOURCE);
            die $@ if !defined $BEM{$bundle_file} && $@;
        } catch {
            handle_js_error($_);
        };
    }

    return $BEM{$bundle_file};
}
}


=head2 process_bem

    Обертка для доступа к %BEM

=cut
sub process_bem
{
    my ($reqid, $params, %opt) = @_;
    my $profile = Yandex::Trace::new_profile('template:process_bem');

    unless (is_production()) {
        $params->{log_schema_validate_errors} = sub {
            my $log = Yandex::Log->new(
                log_file_name => 'validate_errors.log',
                date_suf => "%Y%m%d",
            );
            $log->out(@_);
        };
    }

    my $use_external_hashsum_and_bundles = 0;
    if (-f "$Settings::USE_EXTERNAL_HASHSUM_AND_BUNDLES_FLAG") {
        $use_external_hashsum_and_bundles = 1;
    }

    if (!$use_external_hashsum_and_bundles) {
        $params->{read_schema} = \&VarsSchema::read_schema;
        $params->{read_schema_bundle} = \&VarsSchema::read_schema_bundle;
    }
    
    if (is_beta()) {
        if (-f "$Settings::LOCK_ROOT/validatevars") {
            $params->{logvars} = sub {
                my $block = shift;
                my $errors = VarsSchema::validate_vars($block, $params);
                if (@$errors) {
                    my $log = Yandex::Log->new(
                        log_file_name => 'validatevars.log',
                        date_suf => "%Y%m%d",
                    );
                    $_->{path} = join('.', @{$_->{path}}) for @$errors;
                    $log->out("$reqid\t$block\n".to_json($errors, {canonical => 1, pretty => 1}));
                }
            };
        } elsif (-f "$Settings::LOCK_ROOT/logvars") {
            $params->{logvars} = sub { VarsSchema::logvars($_[0], $params) };
        }
    }

    my $operator_client_id = dynamic_predefine($reqid)->{operator_client_id};

    my $static_file_hashsums = "";
    my $preload_manifest = "";
    
    if (!$use_external_hashsum_and_bundles) {
        $static_file_hashsums = get_static_file_hashsums(source => $opt{source} // $DEFAULT_SOURCE);
        $preload_manifest = Direct::PreloadManifest::get_preload_manifest(lang => Yandex::I18n::current_lang());
    }
    
    my $exp = "";

    my $is_enable_long_term_caching = Client::ClientFeatures::is_enable_long_term_caching($operator_client_id);
    if ($is_enable_long_term_caching) {
        $exp = "enable_long_term_caching";
        
        if (!$use_external_hashsum_and_bundles) {
            $static_file_hashsums = get_static_exp_files_hash($exp, source => $opt{source} // $DEFAULT_SOURCE);
            $preload_manifest = Direct::PreloadManifest::get_preload_manifest(
                exp => $exp,
                lang => Yandex::I18n::current_lang()
            );
        }
    }

    my $is_svg_sprite_loader_plugin_disabled = Client::ClientFeatures::is_svg_sprite_loader_plugin_disabled($operator_client_id);
    if ($is_svg_sprite_loader_plugin_disabled) {
        $exp = "disable_svg_sprite_loader_plugin";
        
        if (!$use_external_hashsum_and_bundles) {
            $static_file_hashsums = get_static_exp_files_hash($exp, source => $opt{source} // $DEFAULT_SOURCE);
            $preload_manifest = Direct::PreloadManifest::get_preload_manifest(
                exp => $exp,
                lang => Yandex::I18n::current_lang()
            );
        }
    }

    if (!$use_external_hashsum_and_bundles && $Settings::DNA_OVERRIDE_HASHSUM_ALLOWED && is_beta() && defined dynamic_predefine($reqid)->{COOKIES}->{"override_hashsums"}) {
        try {
            my $override_hashsums = decode_json(dynamic_predefine($reqid)->{COOKIES}->{"override_hashsums"});
            while (my ($key, $val) = each %$override_hashsums) {
                $static_file_hashsums->{$key} = $val;
            }
        };
    }

    add_dynamic_predefine($reqid, { static_file_hashsums => $static_file_hashsums });
    my $ctx_opt = hash_cut \%opt, qw/safe_json/;
    my $ctx_data = prepare_ctx($reqid, $params, %$ctx_opt);

    # my $is_external_templating = $ENV{EXTERNAL_TEMPLATING} && $EXTERNAL_TEMPLATING_CMDS->{$ctx_data->{cmd}};
    my $bunlde_opt = $opt{bundle} // '';
    my $is_external_templating = 1;

    if ($is_external_templating) {
        $ctx_data->{is_external_templating} = 1; #параметр используется для отображения способа шаблонизации в строке состояния на бетах
        $ctx_data->{template_bundle} = $opt{bundle} || 'direct';
    }

    if (!$use_external_hashsum_and_bundles) {
        $ctx_data->{inline_script} = Direct::InlineScript::get_file_content($ctx_data->{lang}, $static_file_hashsums);
        $ctx_data->{global_vars_file} = Direct::GlobalVars::get_file_content();
    }

    # preload manifest необходим только для контроллера showDna
    if ($ctx_data->{cmd} eq 'showDna') {
        if (!$use_external_hashsum_and_bundles) {
            $ctx_data->{preload_manifest} = $preload_manifest;
        }
        
        if ($exp) {
            $ctx_data->{exp} = $exp;
        }
        
        $ctx_data->{is_preload_assets_enabled} = Client::ClientFeatures::is_preload_assets_enabled($operator_client_id);
        $ctx_data->{is_prefetch_assets_enabled} = Client::ClientFeatures::is_prefetch_assets_enabled($operator_client_id);
        $ctx_data->{is_font_preloading_enabled} = Client::ClientFeatures::is_font_preloading_enabled($operator_client_id);
    }

    my $ctx = format_ctx($ctx_data, %$ctx_opt);

    # на бетах и ТС по параметру get_vars не процессим шаблон, а отдаем переменные (для тестов и т.п.)
    if (!is_production() && $ctx_data->{is_internal_ip} && $ctx_data->{FORM}->{get_vars}) {
        return $ctx->{data};
    } elsif (!$use_external_hashsum_and_bundles && $ctx_data->{is_internal_ip} && $ctx_data->{FORM}->{get_vars}) {
        return $ctx->{data};
    }

    my $result;
    if ($is_external_templating) {
        # будущее: шаблонизация через report-renderer

        die 'empty $EXTERNAL_TEMPLATING_URL' unless $EXTERNAL_TEMPLATING_URL;

        my $profile = Yandex::Trace::new_profile('template:js_templater');
        my $resp = http_parallel_request(
            POST => {
                1 => {
                    url => $EXTERNAL_TEMPLATING_URL,
                    body => Encode::encode_utf8($ctx->{data}),
                    headers => {
                        'Content-type'   => 'application/json;charset=utf-8',
                    },
                }
            },
            timeout => 600,
        );
        undef $profile;
        $resp = $resp->{1};

        die "External templating error: ".to_json($resp) unless $resp->{is_success};

        $result = decode_utf8($resp->{content});
    } else {
        # прошлое: шаблонизация через v8-биндинг
        my $bem = init_bem(%opt);

        $result = eval {$bem->($ctx)};
        handle_js_error($@) if $@;
    }

    if ($ctx->{save_time_after_tt}) {
        $ctx->{save_time_after_tt}->();
    }

    return $result;
}



=head2 notify_funcs_in_data

    Логируем передаваемые в клиентский шаблонизатор функции
    @see DIRECT-61093

=cut

sub notify_funcs_in_data {
    my ($reqid, $cmd, $funcs) = @_;

    state $log;
    $log ||= Yandex::Log->new(
        log_file_name => "frontend.funcs-in-data",
        date_suf => "%Y%m%d",
    );

    my @func_names = keys $funcs;

    my %logData = (
        reqid => $reqid,
        cmd => $cmd,
        funcs => \@func_names
    );

    $log->out(to_json(\%logData))
}


=head2 prepare_ctx

=cut

sub prepare_ctx
{
    my ($reqid, $params, %opt) = @_;
    #### Здесь можно выкинуть ненужные переменные
    my %exclude_from_predefine = map {$_ => 1}qw/
    help
    support
    /;
    my %exclude_from_dynamic_predefine = map {$_ => 1}qw/
    /;
    ####

    my $ctx = {};
    my $predefine = predefine();
    my $dynamic_predefine = dynamic_predefine($reqid);
    for my $key (keys %$predefine){
        next if $exclude_from_predefine{$key};
        $ctx->{$key} = $predefine->{$key};
    }
    for my $key (keys %$dynamic_predefine){
        next if $exclude_from_dynamic_predefine{$key};
        $ctx->{$key} = $dynamic_predefine->{$key};
    }
    hash_merge $ctx, $params;
    $ctx->{reqid} = $ctx->{reqid}."";

    return $ctx;
}

=head2 format_ctx

    Разделяет "данные" на данные и код;
    это делается здесь, потому что содержимое, которое попадает в ctx, формируется
    в множестве разных мест в коде Директа, и разделить их везде не получается
    в итоге данные передаются в bem как JSON, а код как есть
=cut

sub format_ctx
{
    my ($ctx, %opt) = @_;

    my ($ctx_data, $ctx_code) = ( {}, {} );
    while (my ($key, $val) = each %$ctx) {
        if ( ref $val && ref $val eq 'CODE' ) {
            $ctx_code->{$key} = $val;
        } else {
            $ctx_data->{$key} = $val;
        }
    }

    my $json_opt = {convert_blessed => 1};
    if ($opt{safe_json}) {
        $json_opt->{allow_unknown} = 1;
        $json_opt->{allow_blessed} = 1;
    }

    # hack: защищаемся от convert_blessed_universally
    delete local $UNIVERSAL::{TO_JSON};

    if (!is_production()) {
        notify_funcs_in_data($ctx->{reqid}, $ctx_data->{cmd}, $ctx_code);
    }

    if (!is_production()) {
        if ($ctx_data->{is_internal_ip} && $ctx_data->{COOKIES}->{get_vars}) {
            $ctx_data->{DUMPVARS} = to_json($ctx_data, $json_opt);
        }
    }

    # Не хотим, чтобы в шаблонизатор передавались чувствительные данные
    # Вообще правильно было бы наоборот, иметь явный список кук, нужны для шаблонизации, и передавать только их
    delete @{ $ctx_data->{COOKIES} }{qw/Session_id sessionid2 secure_session_id ya_sess_id/};

    return {
        data => to_json($ctx_data, $json_opt),
        funcs => $ctx_code,
    };
}


=head2 handle_js_error($error)

    Парсим сообщение об ошибке от v8, добавляем контекст исходного кода

=cut

sub handle_js_error
{
    my $error = shift;

    if ($error =~ /EVAL:(\d+)/) {
        my $line_number = $1;
        my @lines = split /\r?\n/, $JS_CACHE{$LAST_USED_BUNDLE_FILE}->{source};
        die "$LAST_USED_BUNDLE_FILE:$line_number\n$lines[$line_number - 1]\n$error";
    }
    die $error;
}


=head2 get_bemserver_port

    Возвращаем порт, на котором должен работать bemserver
    Если bemserver не должен работать, возвращаем undef
    Падаем, если не смогли определить порт беты

=cut

sub get_bemserver_port
{
    return undef if !-f "$Settings::LOCK_ROOT/bemserver" && !-f "$Settings::LOCK_ROOT/enbserver";
    if ($Settings::ROOT =~ /(\d{4})$/) {
        return $1 + 30000;
    } else {
        die "unexpected root $Settings::ROOT";
    }
}


=head2 query_bemserver($url, $type)

    Обеспечиваем работу bemserver'а и проксируем его ответ на GET $url
    TODO если этим никто не пользуется то давайте выпилим

=cut

sub query_bemserver
{
    my $url = shift;
    my $type = shift;

    my $port = get_bemserver_port() or die "bem server is off, create $Settings::LOCK_ROOT/bemserver";
    ensure_bemserver($port, $type);
    return decode 'utf8', http_get("http://localhost:$port$url");
}


=head2 ensure_bemserver($port, $type)

    Если никто не отвечает на порту $port, поднимаем bemserver/enbserver

=cut

sub ensure_bemserver
{
    my $port = shift;
    my $type = shift;

    if (system('nc', '-z', 'localhost', $port)) { # non-zero exit means that port is closed
        system("start-stop-daemon -d $Settings::ROOT/data3 -S -x $Settings::ROOT/data3/node_modules/.bin/$type server -- -p $port &");
        sleep 1; # it takes some time to init
    }
}

=head2 get_file_content($filename)

    Резолвим имя файла относительно $Settings::ROOT/data
    Отдаем контент через Yandex::LiveFile

=cut

{
my $cache;
sub get_file_content
{
    my $filename = shift;

    my $fullpath = realpath("$Settings::ROOT/data/$filename");
    unless ( $fullpath && $fullpath =~ m{^\Q$Settings::ROOT/data\E} ) {
        die "Invalid filename $filename";
    }

    $cache ||= {};

    $cache->{$filename} ||= Yandex::LiveFile->new(filename => "$Settings::ROOT/data/$filename");

    return $cache->{$filename}->data;
}
}


sub _log_from_template
{
    my ($logname, @data) = @_;
    my $log = Yandex::Log->new(
        log_file_name => "frontend.$logname",
        date_suf => "%Y%m%d",
    );
    $log->out(@data);
    return;
}

1;
